/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import javax.xml.catalog.CatalogException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.basex.core.MainOptions;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.util.NSContext;
import org.basex.query.util.UriResolver;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.format.DecFormatter;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Uri;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenObjectMap;
import org.xml.sax.InputSource;

public final class StaticContext {
    public final TokenObjectMap<DecFormatter> decFormats = new TokenObjectMap();
    public final NSContext ns = new NSContext();
    public final boolean mixUpdates;
    public final boolean withdb;
    public Collation collation;
    public byte[] elemNS;
    public byte[] funcNS;
    public QNm module;
    public boolean strip;
    public boolean ordered = true;
    public boolean orderGreatest;
    public boolean spaces;
    public boolean preserveNS = true;
    public boolean inheritNS = true;
    public SeqType contextType;
    UriResolver resolver;
    private final URIResolver uriResolver;
    private Uri baseURI = Uri.EMPTY;

    public StaticContext(QueryContext qc) {
        MainOptions mopts = qc.context.options;
        this.mixUpdates = mopts.get(MainOptions.MIXUPDATES);
        this.withdb = mopts.get(MainOptions.WITHDB);
        this.uriResolver = mopts.resolver().uriResolver();
    }

    void namespace(String prefix, String uri) throws QueryException {
        if (prefix.isEmpty()) {
            this.elemNS = uri.isEmpty() ? null : Token.token(uri);
        } else if (uri.isEmpty()) {
            this.ns.delete(Token.token(prefix));
        } else {
            this.ns.add(Token.token(prefix), Token.token(uri), null);
        }
    }

    public Uri baseURI() {
        return this.baseURI;
    }

    public void baseURI(String uri) {
        Object string = "";
        if (uri != null) {
            if (uri.isEmpty()) {
                return;
            }
            Object object = string = IO.get(uri) instanceof IOContent ? uri : this.resolve(uri).url();
            if (!Strings.endsWith((String)string, '/') && (Strings.endsWith(uri, '.') || Strings.endsWith(uri, '/'))) {
                string = (String)string + "/";
            }
        }
        this.baseURI = Uri.get((String)string);
    }

    public IO baseIO() {
        return this.baseURI == Uri.EMPTY ? null : IO.get(Token.string(this.baseURI.string()));
    }

    public IO resolve(String path) {
        return this.resolve(path, null);
    }

    public IO resolve(String path, String uri) {
        if (this.resolver != null) {
            return this.resolver.resolve(path, uri, this.baseURI);
        }
        IO baseIO = this.baseIO();
        if (baseIO == null) {
            return IO.get(path);
        }
        if (this.uriResolver != null) {
            try {
                String id;
                InputSource inputSource;
                Source s = this.uriResolver.resolve(path, baseIO.path());
                if (s instanceof SAXSource) {
                    SAXSource ss = (SAXSource)s;
                    inputSource = ss.getInputSource();
                } else {
                    inputSource = null;
                }
                InputSource is = inputSource;
                String string = id = is != null ? is.getSystemId() : null;
                if (id != null) {
                    return IO.get(id);
                }
            }
            catch (CatalogException | TransformerException ex) {
                Util.debug(ex);
            }
        }
        return baseIO.merge(path);
    }

    public synchronized DecFormatter decFormat(QNm name, InputInfo info) throws QueryException {
        byte[] id = name.unique();
        DecFormatter df = this.decFormats.get(id);
        if (df == null) {
            DecFormatter decFormatter = df = Token.eq(id, Token.EMPTY) ? new DecFormatter() : DecFormatter.forLanguage(id, info);
            if (df != null) {
                this.decFormats.put(id, df);
            }
        }
        return df;
    }

    public String toString() {
        return Util.className(this) + "[" + String.valueOf(this.baseIO()) + "]";
    }
}

