/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.DefaultRankingFunction;
import org.eclipse.sisu.inject.ImplicitBindings;
import org.eclipse.sisu.inject.InjectorBindings;
import org.eclipse.sisu.inject.LocatedBeans;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.MildConcurrentValues;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.inject.RankedBindings;
import org.eclipse.sisu.inject.RankedSequence;
import org.eclipse.sisu.inject.TypeArguments;
import org.eclipse.sisu.inject.WatchedBeans;
import org.eclipse.sisu.inject.Weak;

@Singleton
public final class DefaultBeanLocator
implements MutableBeanLocator {
    private final RankedSequence<BindingPublisher> publishers = new RankedSequence();
    private final ConcurrentMap<Long, RankedBindings> cachedBindings = Weak.concurrentValues(256, 8);
    private final Map<WatchedBeans, Object> cachedWatchers = Weak.values();
    private final ImplicitBindings implicitBindings = new ImplicitBindings(this.publishers);
    private final Long[] typeIdHolder = new Long[1];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<BeanEntry> locate(Key key2) {
        TypeLiteral type2 = key2.getTypeLiteral();
        RankedBindings bindings = this.fetchBindings(type2, null);
        if (bindings == null) {
            ConcurrentMap<Long, RankedBindings> concurrentMap = this.cachedBindings;
            synchronized (concurrentMap) {
                bindings = this.fetchBindings(type2, this.typeIdHolder);
                if (bindings == null) {
                    bindings = new RankedBindings(type2, this.publishers);
                    this.cachedBindings.put(this.typeIdHolder[0], bindings);
                }
            }
        }
        boolean isImplicit = key2.getAnnotationType() == null && TypeArguments.isImplicit(type2);
        return new LocatedBeans(key2, bindings, isImplicit ? this.implicitBindings : null);
    }

    public synchronized void watch(Key key2, Mediator mediator, Object watcher) {
        WatchedBeans beans = new WatchedBeans(key2, mediator, watcher);
        for (BindingPublisher p : this.publishers()) {
            p.subscribe(beans);
        }
        this.cachedWatchers.put(beans, watcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean add(BindingPublisher publisher) {
        if (this.publishers.contains(publisher)) {
            return false;
        }
        Logs.trace("Add publisher: {}", publisher, null);
        ConcurrentMap<Long, RankedBindings> concurrentMap = this.cachedBindings;
        synchronized (concurrentMap) {
            int rank = publisher.maxBindingRank();
            this.publishers.insert(publisher, rank);
            for (RankedBindings bindings : this.cachedBindings.values()) {
                bindings.add(publisher, rank);
            }
        }
        for (WatchedBeans beans : new ArrayList<WatchedBeans>(this.cachedWatchers.keySet())) {
            publisher.subscribe(beans);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean remove(BindingPublisher publisher) {
        BindingPublisher oldPublisher;
        ConcurrentMap<Long, RankedBindings> concurrentMap = this.cachedBindings;
        synchronized (concurrentMap) {
            block6: {
                oldPublisher = this.publishers.remove(publisher);
                if (oldPublisher != null) break block6;
                return false;
            }
            Logs.trace("Remove publisher: {}", oldPublisher, null);
            for (RankedBindings bindings : this.cachedBindings.values()) {
                bindings.remove(oldPublisher);
            }
        }
        for (WatchedBeans beans : this.cachedWatchers.keySet()) {
            oldPublisher.unsubscribe(beans);
        }
        ((MildConcurrentValues)this.cachedBindings).compact();
        return true;
    }

    @Override
    public Iterable<BindingPublisher> publishers() {
        return this.publishers.snapshot();
    }

    @Override
    public synchronized void clear() {
        for (BindingPublisher p : this.publishers()) {
            this.remove(p);
        }
    }

    @Override
    public void add(Injector injector, int rank) {
        this.add(new InjectorBindings(injector, new DefaultRankingFunction(rank)));
    }

    @Override
    public void remove(Injector injector) {
        this.remove(new InjectorBindings(injector, null));
    }

    private RankedBindings fetchBindings(TypeLiteral type2, Long[] idReturn) {
        RankedBindings result;
        int loaderHash = System.identityHashCode(type2.getRawType().getClassLoader());
        long id = (long)type2.hashCode() << 32 | 0xFFFFFFFFL & (long)loaderHash;
        while ((result = (RankedBindings)this.cachedBindings.get(id)) != null && !type2.equals(result.type())) {
            ++id;
        }
        if (idReturn != null) {
            idReturn[0] = id;
        }
        return result;
    }

    @Inject
    void autoPublish(Injector injector) {
        DefaultBeanLocator.staticAutoPublish(this, injector);
    }

    @Inject
    static void staticAutoPublish(MutableBeanLocator locator, Injector injector) {
        locator.add(new InjectorBindings(injector));
    }
}

