/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.data.ExecuteInsertBatchImpl;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.utils.CommonUtils;

public class ExecuteBatchWithMultipleInsert
extends ExecuteInsertBatchImpl {
    private final DBCExecutionSource source;
    private DBSTable table;

    public ExecuteBatchWithMultipleInsert(@NotNull DBSAttributeBase[] attributes, @Nullable DBDDataReceiver keysReceiver, boolean reuseStatement, @NotNull DBCSession session, @NotNull DBCExecutionSource source, @NotNull DBSTable table) {
        super(attributes, keysReceiver, reuseStatement, session, source, table, false);
        this.source = source;
        this.table = table;
    }

    @Override
    protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
        int paramIndex = 0;
        int handlersLength = handlers.length;
        int attributeCount = 0;
        Object[] objectArray = attributeValues;
        int n = attributeValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object attribute = objectArray[n2];
            if (!DBUtils.isPseudoAttribute(this.attributes[attributeCount])) {
                handlers[attributeCount].bindValueObject(statement.getSession(), statement, this.attributes[attributeCount], paramIndex++, attribute);
                if (++attributeCount == handlersLength) {
                    attributeCount = 0;
                }
            }
            ++n2;
        }
    }

    @Override
    @NotNull
    protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, Map<String, Object> options) throws DBCException {
        StringBuilder queryForStatement = this.prepareQueryForStatement(session, handlers, attributeValues, this.attributes, this.table, true, options);
        DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, queryForStatement.toString(), false, false, this.keysReceiver != null);
        dbStat.setStatementSource(this.source);
        return dbStat;
    }

    @Override
    @NotNull
    public DBCStatistics processBatch(@NotNull DBCSession session, @Nullable List<DBEPersistAction> actions, Map<String, Object> options) throws DBException {
        int attributesLength = this.attributes.length;
        DBDValueHandler[] handlers = new DBDValueHandler[attributesLength];
        int i = 0;
        while (i < attributesLength) {
            handlers[i] = this.attributes[i] instanceof DBDAttributeBinding ? ((DBDAttributeBinding)this.attributes[i]).getValueHandler() : DBUtils.findValueHandler(session, (DBSTypedObject)this.attributes[i]);
            ++i;
        }
        DBCStatistics statistics = new DBCStatistics();
        try (DBCStatement batchStatement = null;){
            int multiRowInsertBatchSize = CommonUtils.toInt((Object)options.get("data.manipulate.multiInsertBatchSize"), (int)100);
            boolean skipBindValues = CommonUtils.toBoolean((Object)options.get("data.manipulate.skipBindValues"));
            int rowsCount = this.values.size();
            ArrayList multiRowInsertBatchValuesList = new ArrayList();
            int i2 = 0;
            while (i2 < rowsCount) {
                if (session.getProgressMonitor().isCanceled()) break;
                Object[] objects = (Object[])this.values.get(i2);
                if (i2 == rowsCount - 1 || i2 != 0 && i2 % multiRowInsertBatchSize == 0) {
                    if (i2 == rowsCount - 1) {
                        Collections.addAll(multiRowInsertBatchValuesList, objects);
                        Object[] allMultiInsertValues = multiRowInsertBatchValuesList.toArray(new Object[0]);
                        Throwable throwable = null;
                        Object var16_18 = null;
                        try (DBCStatement statement = this.prepareStatement(session, handlers, allMultiInsertValues, options);){
                            this.bindAndFlushStatement(handlers, statistics, statement, allMultiInsertValues, skipBindValues);
                            multiRowInsertBatchValuesList.clear();
                            break;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    Object[] allMultiInsertValuesBatch = multiRowInsertBatchValuesList.toArray(new Object[0]);
                    batchStatement = this.prepareStatement(session, handlers, allMultiInsertValuesBatch, options);
                    this.bindAndFlushStatement(handlers, statistics, batchStatement, allMultiInsertValuesBatch, skipBindValues);
                    multiRowInsertBatchValuesList.clear();
                }
                Collections.addAll(multiRowInsertBatchValuesList, objects);
                ++i2;
            }
            this.values.clear();
        }
        return statistics;
    }

    private void bindAndFlushStatement(DBDValueHandler[] handlers, DBCStatistics statistics, DBCStatement batchStatement, Object[] allMultiInsertValues, boolean skipBindValues) throws DBCException {
        statistics.setQueryText(batchStatement.getQueryString());
        statistics.addStatementsCount();
        if (!skipBindValues) {
            this.bindStatement(handlers, batchStatement, allMultiInsertValues);
        }
        batchStatement.addToBatch();
        this.flushBatch(statistics, batchStatement);
    }
}

