/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreConstraintManager;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreTableColumnManager;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreIndex;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRule;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeignKey;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableReal;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTrigger;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionComment;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLTableManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.utils.CommonUtils;

public abstract class PostgreTableManagerBase
extends SQLTableManager<PostgreTableBase, PostgreSchema> {
    protected void addObjectExtraActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.NestedObjectCommand<PostgreTableBase, SQLObjectEditor.PropertyHandler> command, @NotNull Map<String, Object> options) {
        boolean showComments;
        Object descProp;
        boolean isDDL = CommonUtils.getOption(options, (String)"ddl.source");
        PostgreTableBase table = (PostgreTableBase)command.getObject();
        String comment = !table.isPersisted() ? ((descProp = command.getProperty((Object)"description")) != null ? descProp.toString() : null) : table.getDescription();
        boolean bl = showComments = CommonUtils.getOption(options, (String)"ddl.includeComments") || CommonUtils.getOption(options, (String)"object.save");
        if (showComments && !CommonUtils.isEmpty((String)comment) || command.hasProperty((Object)"description")) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment table", "COMMENT ON " + table.getTableTypeName() + " " + table.getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBSObject)table, (String)CommonUtils.notEmpty((String)comment))));
        }
        if (isDDL || !table.isPersisted()) {
            PostgreDataSource dataSource = (PostgreDataSource)table.getDataSource();
            boolean addExtraActionComment = ((PostgreDataSource)table.getDataSource()).getContainer().getPreferenceStore().getBoolean("database.meta.extra.ddl.info");
            try {
                Collection<PostgreRule> rules;
                List<PostgreTrigger> triggers;
                boolean hasComments;
                if (showComments) {
                    hasComments = false;
                    for (PostgreTableColumn column : CommonUtils.safeCollection(table.getAttributes(monitor))) {
                        if (CommonUtils.isEmpty((String)column.getDescription())) continue;
                        if (!hasComments && addExtraActionComment) {
                            actions.add((DBEPersistAction)new SQLDatabasePersistActionComment((DBPDataSource)dataSource, "Column comments"));
                        }
                        PostgreTableColumnManager.addColumnCommentAction(actions, column);
                        hasComments = true;
                    }
                }
                if (showComments && !table.isPartition() && !monitor.isCanceled()) {
                    hasComments = false;
                    for (PostgreTableConstraintBase constr : CommonUtils.safeCollection(table.getConstraints(monitor))) {
                        if (CommonUtils.isEmpty((String)constr.getDescription())) continue;
                        if (!hasComments && addExtraActionComment) {
                            actions.add((DBEPersistAction)new SQLDatabasePersistActionComment((DBPDataSource)dataSource, "Constraint comments"));
                        }
                        PostgreConstraintManager.addConstraintCommentAction(actions, constr);
                        hasComments = true;
                    }
                    for (DBSEntityAssociation fk : CommonUtils.safeCollection(table.getAssociations(monitor))) {
                        if (!(fk instanceof PostgreTableForeignKey) || CommonUtils.isEmpty((String)fk.getDescription())) continue;
                        if (!hasComments && addExtraActionComment) {
                            actions.add((DBEPersistAction)new SQLDatabasePersistActionComment((DBPDataSource)dataSource, "Foreign key comments"));
                        }
                        PostgreConstraintManager.addConstraintCommentAction(actions, (PostgreTableForeignKey)fk);
                        hasComments = true;
                    }
                }
                if (!table.isPartition() && !monitor.isCanceled() && ((PostgreDataSource)table.getDataSource()).getServerType().supportsAlterStorageStrategy() && !((PostgreDataSource)table.getDataSource()).getServerType().supportsStorageModifier()) {
                    boolean hasStorage = false;
                    for (PostgreTableColumn column : CommonUtils.safeCollection(table.getAttributes(monitor))) {
                        if (column.isHidden() || column.hasDefaultStorage()) continue;
                        if (!hasStorage && addExtraActionComment) {
                            actions.add((DBEPersistAction)new SQLDatabasePersistActionComment((DBPDataSource)dataSource, "Column storage"));
                        }
                        PostgreTableColumnManager.addColumnStorageAction(actions, column);
                        hasStorage = true;
                    }
                }
                if (table instanceof PostgreTableReal && !table.isPartition() && !monitor.isCanceled() && !CommonUtils.isEmpty(triggers = ((PostgreTableReal)table).getTriggers(monitor))) {
                    if (addExtraActionComment) {
                        actions.add((DBEPersistAction)new SQLDatabasePersistActionComment((DBPDataSource)dataSource, "Table Triggers"));
                    }
                    for (PostgreTrigger trigger : triggers) {
                        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create trigger", trigger.getObjectDefinitionText(monitor, options)));
                    }
                }
                if (table instanceof PostgreTableReal && !table.isPartition() && !monitor.isCanceled() && !CommonUtils.isEmpty(rules = ((PostgreTableReal)table).getRules(monitor))) {
                    if (addExtraActionComment) {
                        actions.add((DBEPersistAction)new SQLDatabasePersistActionComment((DBPDataSource)dataSource, "Table Rules"));
                    }
                    for (PostgreRule rule : rules) {
                        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create rule", rule.getObjectDefinitionText(monitor, options)));
                    }
                }
                if (CommonUtils.getOption(options, (String)"ddl.includePartitions") && table instanceof PostgreTable && !monitor.isCanceled()) {
                    PostgreTable postgreTable = (PostgreTable)table;
                    List<PostgreTableBase> partitions = postgreTable.getPartitions(monitor);
                    if (postgreTable.hasPartitions() && !CommonUtils.isEmpty(partitions)) {
                        if (addExtraActionComment) {
                            actions.add((DBEPersistAction)new SQLDatabasePersistActionComment((DBPDataSource)dataSource, "Partitions"));
                        }
                        for (PostgreTableBase partition : partitions) {
                            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create partition", partition.getObjectDefinitionText(monitor, options)));
                        }
                    }
                }
                if (isDDL && !table.isPartition() && !monitor.isCanceled()) {
                    PostgreUtils.getObjectGrantPermissionActions(monitor, table, actions, options);
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
    }

    protected boolean isIncludeIndexInDDL(DBRProgressMonitor monitor, DBSTableIndex index) throws DBException {
        return !((PostgreIndex)index).isPrimaryKeyIndex() && super.isIncludeIndexInDDL(monitor, index);
    }

    protected boolean isIncludeDropInDDL(@NotNull PostgreTableBase table) {
        return !table.isPartition();
    }
}

