/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.kingbase.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.kingbase.model.KingbaseFunction;
import org.jkiss.dbeaver.ext.kingbase.model.KingbaseProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureKind;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreServerExtension;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class KingbaseSchema
extends PostgreSchema {
    public long systemOid = 16384L;
    private final ProceduresCache proceduresCache = new ProceduresCache();
    private final FunctionsCache functionsCache = new FunctionsCache();

    public KingbaseSchema(PostgreDatabase owner, String name, JDBCResultSet resultSet) throws SQLException {
        super(owner, name, (ResultSet)resultSet);
    }

    public KingbaseSchema(PostgreDatabase database, String name, PostgreRole owner) {
        super(database, name, owner);
    }

    public boolean isSystem() {
        return this.oid < this.systemOid && !this.name.toLowerCase(Locale.ENGLISH).contains("public");
    }

    public boolean isUtility() {
        return false;
    }

    public static boolean isUtilitySchema(String schema) {
        return false;
    }

    public ProceduresCache getKingbaseProceduresCache() {
        return this.proceduresCache;
    }

    public FunctionsCache getKingbaseFunctionsCache() {
        return this.functionsCache;
    }

    @Association
    public List<KingbaseProcedure> getKingbaseProcedures(DBRProgressMonitor monitor) throws DBException {
        List<KingbaseProcedure> list = this.getKingbaseProceduresCache().getAllObjects(monitor, (DBSObject)this).stream().filter(e -> e.getPropackageid() == 0L && e.getKind() == PostgreProcedureKind.p).collect(Collectors.toList());
        return list;
    }

    @Association
    public List<KingbaseFunction> getKingbaseFunctions(DBRProgressMonitor monitor) throws DBException {
        List<KingbaseFunction> list = this.getKingbaseFunctionsCache().getAllObjects(monitor, (DBSObject)this).stream().filter(e -> e.getPropackageid() == 0L && e.getKind() == PostgreProcedureKind.f).collect(Collectors.toList());
        return list;
    }

    public static class FunctionsCache
    extends JDBCObjectLookupCache<KingbaseSchema, KingbaseFunction> {
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull KingbaseSchema owner, @Nullable KingbaseFunction object, @Nullable String objectName) throws SQLException {
            PostgreServerExtension serverType = owner.getDataSource().getServerType();
            String oidColumn = serverType.getProceduresOidColumn();
            String tableName = serverType.getProceduresSystemTable().contains("pg_") ? serverType.getProceduresSystemTable().replaceAll("pg_", "sys_") : serverType.getProceduresSystemTable();
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT p." + oidColumn + " as poid,p.*,sys_catalog.sys_get_expr(p.proargdefaults, 0) as arg_defaults,d.description\nFROM sys_catalog." + tableName + " p\nLEFT OUTER JOIN sys_catalog.sys_description d ON d.objoid=p." + oidColumn + " AND d.objsubid = 0\nWHERE p.pronamespace=?" + (String)(object == null ? "" : " AND p." + oidColumn + "=?") + "\nORDER BY p.proname");
            dbStat.setLong(1, owner.getObjectId());
            if (object != null) {
                dbStat.setLong(2, object.getObjectId());
            }
            return dbStat;
        }

        protected KingbaseFunction fetchObject(@NotNull JDBCSession session, @NotNull KingbaseSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new KingbaseFunction(session.getProgressMonitor(), owner, (ResultSet)dbResult);
        }
    }

    public static class ProceduresCache
    extends JDBCObjectLookupCache<KingbaseSchema, KingbaseProcedure> {
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull KingbaseSchema owner, @Nullable KingbaseProcedure object, @Nullable String objectName) throws SQLException {
            PostgreServerExtension serverType = owner.getDataSource().getServerType();
            String oidColumn = serverType.getProceduresOidColumn();
            String tableName = serverType.getProceduresSystemTable().contains("pg_") ? serverType.getProceduresSystemTable().replaceAll("pg_", "sys_") : serverType.getProceduresSystemTable();
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT p." + oidColumn + " as poid,p.*,sys_catalog.sys_get_expr(p.proargdefaults, 0) as arg_defaults,d.description\nFROM sys_catalog." + tableName + " p\nLEFT OUTER JOIN sys_catalog.sys_description d ON d.objoid=p." + oidColumn + " AND d.objsubid = 0\nWHERE p.pronamespace=?" + (String)(object == null ? "" : " AND p." + oidColumn + "=?") + "\nORDER BY p.proname");
            dbStat.setLong(1, owner.getObjectId());
            if (object != null) {
                dbStat.setLong(2, object.getObjectId());
            }
            return dbStat;
        }

        protected KingbaseProcedure fetchObject(@NotNull JDBCSession session, @NotNull KingbaseSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new KingbaseProcedure(session.getProgressMonitor(), owner, (ResultSet)dbResult);
        }
    }
}

