/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.security.PublicKey;
import java.util.List;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.SecurityUtils;
import net.schmizz.sshj.transport.verification.OpenSSHKnownHosts;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.net.ssh.SSHJUIMessages;
import org.jkiss.dbeaver.model.net.ssh.SSHUtils;
import org.jkiss.dbeaver.model.net.ssh.config.SSHHostConfiguration;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class KnownHostsVerifier
extends OpenSSHKnownHosts {
    private final SSHHostConfiguration actualHostConfiguration;

    public KnownHostsVerifier(@NotNull File khFile, @NotNull SSHHostConfiguration actualHostConfiguration) throws IOException {
        super(khFile);
        this.actualHostConfiguration = actualHostConfiguration;
    }

    public boolean verify(String hostname, int port, PublicKey key) {
        if (hostname.equals("localhost") || hostname.equals("127.0.0.1")) {
            return true;
        }
        return super.verify(hostname, port, key);
    }

    public List<String> findExistingAlgorithms(String hostname, int port) {
        if (hostname.equals("localhost")) {
            return super.findExistingAlgorithms(this.actualHostConfiguration.hostname(), this.actualHostConfiguration.port());
        }
        return super.findExistingAlgorithms(hostname, port);
    }

    protected boolean hostKeyUnverifiableAction(String hostname, PublicKey key) {
        KeyType type = KeyType.fromKey((Key)key);
        boolean isConfirmed = DBWorkbench.getPlatformUI().confirmAction(SSHJUIMessages.verify_connection_confirmation_title, NLS.bind((String)SSHJUIMessages.verify_connection_confirmation_message, (Object[])new String[]{hostname, type.toString(), SecurityUtils.getFingerprint((PublicKey)key)}), true);
        if (!isConfirmed) {
            return false;
        }
        try {
            this.entries().add(new OpenSSHKnownHosts.HostEntry(null, hostname, KeyType.fromKey((Key)key), key));
            this.write();
            DBWorkbench.getPlatformUI().showWarningMessageBox(SSHJUIMessages.warning_title, NLS.bind((String)SSHJUIMessages.known_host_added_warning_message, (Object)hostname, (Object)type));
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean hostKeyChangedAction(String hostname, PublicKey key) {
        DBWorkbench.getPlatformUI().showWarningMessageBox(SSHJUIMessages.warning_title, NLS.bind((String)SSHJUIMessages.host_key_changed_warning_message, (Object[])new String[]{KeyType.fromKey((Key)key).toString(), SecurityUtils.getFingerprint((PublicKey)key), this.getFile().getAbsolutePath()}));
        return false;
    }

    public void write(OpenSSHKnownHosts.KnownHostEntry entry) throws IOException {
        this.khFile.getParentFile().mkdirs();
        super.write(entry);
        SSHUtils.forcePlatformReloadKnownHostsPreferences();
    }

    public void write() throws IOException {
        this.khFile.getParentFile().mkdirs();
        super.write();
        SSHUtils.forcePlatformReloadKnownHostsPreferences();
    }
}

