// $Id: Doxymain.h 87170 2014-11-26 09:25:51Z gcosmo $

/// \file Doxymain.h
/// \brief The main page for Geant4 Examples code documenation

/*! \mainpage Geant4 Examples

This module collects four sets of user examples aimed to demonstrate to
the user how to make correct use of the GEANT4 toolkit by implementing
in a correct way those user-classes which the user is supposed to
customize in order to define his/her own simulation setup.

The <b>"basic"</b> set of examples is oriented to novice users and covering 
the most typical use-cases of a Geant4 application with keeping simplicity 
and ease of use.

An <b>"extended"</b> set of examples may require some additional libraries besides 
of Geant4. This set covers many specific use cases for actual detector 
simulation. 

An <b>"advanced"</b> set of examples covers the use-cases typical of a 
"toolkit"-oriented kind of development, where real complete applications 
for different simulation studies are provided; may require additional third 
party products to be built.

Most of the examples can be run both in interactive and batch mode, and 
input macro files (*.in) and reference output files (*.out) are provided.
Basic and most of the extended examples are considered part of the
system testing suite for validation of the official releases of the
GEANT4 toolkit. Basic and some of the extended and advanced
examples are also used as "acceptance"-tests for the release process.

See more on each examples category pages:
- \ref README_basic
- \ref README_extended
- <a href="https://twiki.cern.ch/twiki/bin/view/Geant4/AdvancedExamples">
  <b>Advanced Examples </b></a>

The previous set of examples oriented to novice users, <b>"novice"</b>,
has been refactored in "basic" and "extended" examples sets in Geant4 10.0.
The information about the original set of these examples can be found at
\link README_novice this page \endlink.

And more on what is common for all examples:
- \ref README_HowToRun 
- \ref README_HowToRunMT 
- \ref README_HowToNavigate



*/


