//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
/// \file persistency/gdml/G03/include/G03RunAction.hh
/// \brief Definition of the G03RunAction class
//
//
// $Id: G03RunAction.hh 69987 2013-05-21 12:33:52Z gcosmo $
//
// Class G03RunAction
//
// Simple run action class.
//
// ----------------------------------------------------------------------------

#ifndef G03RunAction_h
#define G03RunAction_h 1

#include <iostream>

#include "globals.hh"
#include "G4UserRunAction.hh"

class G4Run;

/// Run action for the GDML extension example

class G03RunAction : public G4UserRunAction
{
  public:

    G03RunAction();
   ~G03RunAction();

    virtual void BeginOfRunAction(const G4Run*);
    virtual void EndOfRunAction(const G4Run*);
      
};

// ----------------------------------------------------------------------------

#endif
