//  Copyright (c) 2007-2020 Hartmut Kaiser
//  Copyright (c)      2011 Bryce Lelbach
//  Copyright (c)      2013 Adrian Serio
//
//  SPDX-License-Identifier: BSL-1.0
//  Distributed under the Boost Software License, Version 1.0. (See accompanying
//  file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

// Do not edit this file! It has been generated by the cmake configuration step.

#pragma once

#include <pika/config.hpp>
#include <pika/config/export_definitions.hpp>
#include <pika/preprocessor/cat.hpp>

#include <boost/version.hpp>

// clang-format off
/// Evaluates to the major version of pika
#define PIKA_VERSION_MAJOR 0
/// Evaluates to the minor version of pika
#define PIKA_VERSION_MINOR 30
/// Evaluates to the patch version of pika
#define PIKA_VERSION_PATCH 1
// clang-format on

/// Evaluates to the pika version:
/// ``PIKA_VERSION_FULL & 0xFF0000 == PIKA_VERSION_MAJOR``
/// ``PIKA_VERSION_FULL & 0x00FF00 == PIKA_VERSION_MINOR``
/// ``PIKA_VERSION_FULL & 0x0000FF == PIKA_VERSION_PATCH``
#define PIKA_VERSION_FULL                                                                          \
    ((PIKA_VERSION_MAJOR << 16) | (PIKA_VERSION_MINOR << 8) | PIKA_VERSION_PATCH)

// clang-format off
/// Evaluates to the release date of this pika version in the format YYYYMMDD.
#define PIKA_VERSION_DATE 20241119

/// Evaluates to the version tag (empty for releases, ``-trunk`` on the
/// development branch, ``-rcX`` on a release candidate.
#define PIKA_VERSION_TAG ""
// clang-format on

#if !defined(PIKA_HAVE_GIT_COMMIT)
# define PIKA_HAVE_GIT_COMMIT "unknown"
#endif

///////////////////////////////////////////////////////////////////////////////
// The version check enforces the major and minor version numbers to match for
// every compilation unit to be compiled.
#define PIKA_CHECK_VERSION                                                                         \
    PIKA_PP_CAT(                                                                                   \
        pika_check_version_, PIKA_PP_CAT(PIKA_VERSION_MAJOR, PIKA_PP_CAT(_, PIKA_VERSION_MINOR)))  \
    /**/

// The version check enforces the major and minor version numbers to match for
// every compilation unit to be compiled.
#define PIKA_CHECK_BOOST_VERSION                                                                   \
    PIKA_PP_CAT(pika_check_boost_version_, BOOST_VERSION)                                          \
    /**/

///////////////////////////////////////////////////////////////////////////////
namespace pika {
    // Helper data structures allowing to automatically detect version problems
    // between applications and the core libraries.
    PIKA_EXPORT extern char const PIKA_CHECK_VERSION[];
    PIKA_EXPORT extern char const PIKA_CHECK_BOOST_VERSION[];
}    // namespace pika

///////////////////////////////////////////////////////////////////////////////
#if !defined(PIKA_EXPORTS) && !defined(PIKA_NO_VERSION_CHECK)

// This is instantiated for each translation unit outside of the pika core
// library, forcing to resolve the variable PIKA_CHECK_VERSION.
namespace {
    // Note: this function is never executed.
# if defined(__GNUG__)
    __attribute__((unused))
# endif
    char const*
    check_pika_version()
    {
        char const* versions[] = {pika::PIKA_CHECK_VERSION, pika::PIKA_CHECK_BOOST_VERSION};
        return versions[0];
    }
}    // namespace
#endif
