---
title: 0.14.2
description: Changes in Typst 0.14.2
---

# Version 0.14.2 (December 12, 2025) { #v0.14.2 }

## Security
- Updated the WebAssembly runtime used for executing [plugins]($plugin). The version used in Typst 0.14.0 and 0.14.1 suffers from a memory handling vulnerability. Based on our investigation, the vulnerability would be very hard to exploit in practice, but an exploit could theoretically be feasible. In any case, **we recommend upgrading to Typst 0.14.2.** This holds in particular for local users. In the web app, the bug is not critical as the browser offers an extra layer of protection.

  Typst 0.13.1 and below are not affected by this vulnerability.

  _Technical details:_ The [`wasmi`](https://github.com/wasmi-labs/wasmi/) WebAssembly runtime versions used in 0.14.0 and 0.14.1 have a _use-after-free_ memory handling bug in certain memory growth situations. Specifically, the bug occurs when the plugin tries to grow its memory, but allocating the requested amount of memory fails. Based on our investigation, the bug is hard to trigger in practice as the WebAssembly linear memory is always limited to 4GB on a technical level and modern operating systems rarely fail to serve a 4GB memory allocation request (typically not even under RAM pressure). Once the bug is triggered, it would also still be very challenging to turn it into an actual exploit. Regardless, we recommend upgrading to Typst 0.14.2 for protection against a potential exploit.

## Diagnostics
- Added a hint when [`array.sorted`] fails because a pair of elements could not be compared. This hint aids with fixing bugs in user code that were surfaced by a change in internal sorting behavior in Typst 0.14.1.

## Contributors
<contributors from="v0.14.1" to="v0.14.2" />
