/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.routines;

import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openstreetmap.josm.data.validation.routines.AbstractValidator;
import org.openstreetmap.josm.tools.Utils;

public class RegexValidator
extends AbstractValidator {
    private final Pattern[] patterns;

    public RegexValidator(String regex) {
        this(regex, true);
    }

    public RegexValidator(String regex, boolean caseSensitive) {
        this(new String[]{regex}, caseSensitive);
    }

    public RegexValidator(String ... regexs) {
        this(regexs, true);
    }

    public RegexValidator(String[] regexs, boolean caseSensitive) {
        if (regexs == null || regexs.length == 0) {
            throw new IllegalArgumentException("Regular expressions are missing");
        }
        this.patterns = new Pattern[regexs.length];
        int flags = caseSensitive ? 0 : 2;
        for (int i = 0; i < regexs.length; ++i) {
            if (Utils.isEmpty(regexs[i])) {
                throw new IllegalArgumentException("Regular expression[" + i + "] is missing");
            }
            this.patterns[i] = Pattern.compile(regexs[i], flags);
        }
    }

    @Override
    public boolean isValid(String value) {
        return value != null && IntStream.range(0, this.patterns.length).anyMatch(i -> this.patterns[i].matcher(value).matches());
    }

    @Override
    public String getValidatorName() {
        return null;
    }

    public String[] match(String value) {
        if (value == null) {
            return null;
        }
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(value);
            if (!matcher.matches()) continue;
            int count = matcher.groupCount();
            return (String[])IntStream.range(0, count).mapToObj(j -> matcher.group(j + 1)).toArray(String[]::new);
        }
        return null;
    }

    public String validate(String value) {
        if (value == null) {
            return null;
        }
        for (Pattern pattern : this.patterns) {
            Matcher matcher = pattern.matcher(value);
            if (!matcher.matches()) continue;
            int count = matcher.groupCount();
            if (count == 1) {
                return matcher.group(1);
            }
            return IntStream.range(0, count).mapToObj(j -> matcher.group(j + 1)).filter(Objects::nonNull).collect(Collectors.joining());
        }
        return null;
    }

    public String toString() {
        return Arrays.stream(this.patterns).map(Pattern::pattern).collect(Collectors.joining(",", "RegexValidator{", "}"));
    }
}

