/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import org.openstreetmap.josm.actions.SplitWayAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.IWaySegment;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.CachingProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MenuScroller;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.util.HighlightHelper;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class SplitMode
extends MapMode {
    static final CachingProperty<Boolean> PREFER_SELECTED_WAYS = new BooleanProperty("split-mode.prefer-selected-ways", true).cached();
    static final CachingProperty<Boolean> IGNORE_DISABLED_WAYS = new BooleanProperty("split-mode.ignore-disabled-ways", true).cached();
    HighlightHelper highlight = new HighlightHelper();

    public SplitMode() {
        super(I18n.tr("Split mode", new Object[0]), "splitway", I18n.tr("Split ways", new Object[0]), Shortcut.registerShortcut("mapmode:split", I18n.tr("Mode: {0}", I18n.tr("Split mode", new Object[0])), 84, 5003), ImageProvider.getCursor("crosshair", null));
    }

    @Override
    public void enterMode() {
        super.enterMode();
        MapView mv = MainApplication.getMap().mapView;
        mv.addMouseListener(this);
        mv.addMouseMotionListener(this);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        MapView mv = MainApplication.getMap().mapView;
        mv.removeMouseMotionListener(this);
        mv.removeMouseListener(this);
        this.removeHighlighting();
    }

    @Override
    public boolean layerIsSupported(Layer l) {
        return this.isEditableDataLayer(l);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        MapView mv = MainApplication.getMap().mapView;
        int mouseDownButton = e.getButton();
        Point mousePos = e.getPoint();
        if (!mv.isActiveLayerVisible() || Boolean.FALSE.equals(this.getValue("active")) || mouseDownButton != 1) {
            return;
        }
        this.updateKeyModifiers(e);
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (ds == null) {
            return;
        }
        ArrayList<Way> selectedWays = new ArrayList<Way>(ds.getSelectedWays());
        Optional<OsmPrimitive> primitiveAtPoint = SplitMode.getPrimitiveAtPoint(e.getPoint());
        if (!primitiveAtPoint.isPresent()) {
            return;
        }
        OsmPrimitive nearestPrimitive = primitiveAtPoint.get();
        if (nearestPrimitive instanceof Node) {
            Node n = (Node)nearestPrimitive;
            List<Way> applicableWays = SplitMode.getApplicableWays(n, selectedWays);
            if (applicableWays.isEmpty()) {
                new Notification(I18n.tr("The selected node is not in the middle of any non-closed way.", new Object[0])).setIcon(2).show();
                return;
            }
            if (applicableWays.size() > 1) {
                this.createPopup(n, applicableWays).show(mv, mousePos.x, mousePos.y);
            } else {
                Way splitWay = applicableWays.get(0);
                SplitWayAction.doSplitWayShowSegmentSelection(splitWay, Collections.singletonList(n), null);
                if (this.updateUserFeedback(e)) {
                    MainApplication.getMap().mapView.repaint();
                }
            }
        } else if (nearestPrimitive instanceof Way && !((Way)nearestPrimitive).isClosed()) {
            this.addNodeAndSplit(mv, mousePos, (Way)nearestPrimitive);
            if (this.updateUserFeedback(e)) {
                MainApplication.getMap().mapView.repaint();
            }
        } else if (nearestPrimitive instanceof Way) {
            new Notification(I18n.tr("Splitting closed ways is not yet implemented.", new Object[0])).setIcon(2).show();
        }
    }

    private void addNodeAndSplit(MapView mv, Point mousePos, Way way) {
        Node mouseLatLon = new Node(mv.getLatLon(mousePos.x, mousePos.y));
        WaySegment closestSegment = Geometry.getClosestWaySegment(way, mouseLatLon);
        EastNorth en = Geometry.closestPointToLine(((Node)closestSegment.getFirstNode()).getEastNorth(), ((Node)closestSegment.getSecondNode()).getEastNorth(), mouseLatLon.getEastNorth());
        mouseLatLon.setEastNorth(en);
        ArrayList<Command> commandList = new ArrayList<Command>();
        AddCommand addPrimitivesCommand = new AddCommand(way.getDataSet(), mouseLatLon);
        commandList.add(addPrimitivesCommand);
        HashSet<Way> commonParentWays = new HashSet<Way>(((Node)closestSegment.getFirstNode()).getParentWays());
        commonParentWays.retainAll(((Node)closestSegment.getSecondNode()).getParentWays());
        if (way.isSelected()) {
            commonParentWays.clear();
            commonParentWays.add(way);
        }
        for (Way parentWay : commonParentWays) {
            for (int i = 0; i < parentWay.getNodesCount() - 1; ++i) {
                IWaySegment<Node, Way> waySegment = IWaySegment.forNodePair(parentWay, parentWay.getNode(i), parentWay.getNode(i + 1));
                if (!closestSegment.isSimilar(waySegment)) continue;
                List<Node> nodes = parentWay.getNodes();
                nodes.add(waySegment.getUpperIndex(), mouseLatLon);
                ChangeNodesCommand changeNodesCommand = new ChangeNodesCommand(parentWay, nodes);
                commandList.add(changeNodesCommand);
            }
        }
        UndoRedoHandler.getInstance().add(SequenceCommand.wrapIfNeeded(I18n.trn("Add node for splitting a way", "Add node for splitting {0} ways", commonParentWays.size(), commonParentWays.size()), commandList));
        if (commonParentWays.size() > 1) {
            this.createPopup(mouseLatLon, commonParentWays).show(mv, mousePos.x, mousePos.y);
        } else {
            SplitWayAction.doSplitWayShowSegmentSelection(way, Collections.singletonList(mouseLatLon), null);
            if (way.getDataSet().selectionEmpty()) {
                way.getDataSet().setSelected(way);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.updateUserFeedback(e)) {
            MainApplication.getMap().mapView.repaint();
        }
    }

    @Override
    public String getModeHelpText() {
        return I18n.tr("Click on the location where a way should be split", new Object[0]);
    }

    private static Optional<OsmPrimitive> getPrimitiveAtPoint(Point p) {
        MapView mv = MainApplication.getMap().mapView;
        return Optional.ofNullable(mv.getNearestNodeOrWay(p, mv.isSelectablePredicate, true));
    }

    private static List<Way> getApplicableWays(Node n, Collection<Way> preferredWays) {
        List<Way> parentWays = n.getParentWays();
        List<Way> applicableWays = parentWays.stream().filter(w -> w.isDrawable() && (!w.isDisabled() || IGNORE_DISABLED_WAYS.get() == false) && !w.isClosed() && w.isInnerNode(n)).collect(Collectors.toList());
        if (Boolean.TRUE.equals(PREFER_SELECTED_WAYS.get()) && preferredWays != null) {
            List preferredApplicableWays = applicableWays.stream().filter(preferredWays::contains).collect(Collectors.toList());
            if (!preferredApplicableWays.isEmpty()) {
                applicableWays = preferredApplicableWays;
            }
        }
        return applicableWays;
    }

    private JPopupMenu createPopup(final Node n, Collection<Way> applicableWays) {
        String menuKey;
        switch (PlatformManager.getPlatform().getMenuShortcutKeyMaskEx()) {
            case 128: {
                menuKey = I18n.trc("SplitMode popup", "Ctrl");
                break;
            }
            case 256: {
                menuKey = I18n.trc("SplitMode popup", "Meta");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown platform menu shortcut key for " + PlatformManager.getPlatform().getOSDescription());
            }
        }
        JPopupMenu pm = new JPopupMenu("<html>" + I18n.tr("Select way to split.<br>Hold {0} for multiple selection.", menuKey) + "</html>");
        MatteBorder titleUnderline = BorderFactory.createMatteBorder(1, 0, 0, 0, pm.getForeground());
        TitledBorder labelBorder = BorderFactory.createTitledBorder(titleUnderline, pm.getLabel(), 2, 1, pm.getFont(), pm.getForeground());
        pm.setBorder(BorderFactory.createCompoundBorder(pm.getBorder(), labelBorder));
        for (final Way w : applicableWays) {
            JMenuItem mi = new JMenuItem(new SplitWayActionConcrete(w, Collections.singletonList(n), null));
            mi.setText("<html>" + SplitMode.createLabelText(w) + "</html>");
            this.addHoverHighlightListener(mi, Arrays.asList(n, w));
            mi.addFocusListener(new FocusAdapter(this){
                final /* synthetic */ SplitMode this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void focusGained(FocusEvent e) {
                    if (this.this$0.highlight.highlightOnly(Arrays.asList(n, w))) {
                        MainApplication.getMap().mapView.repaint();
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (this.this$0.removeHighlighting()) {
                        MainApplication.getMap().mapView.repaint();
                    }
                }
            });
            mi.addActionListener(actionEvent -> {
                this.removeHighlighting();
                this.updateKeyModifiers(actionEvent);
                if (this.platformMenuShortcutKeyMask) {
                    JMenuItem source = (JMenuItem)actionEvent.getSource();
                    JPopupMenu popup = (JPopupMenu)source.getParent();
                    popup.remove(source);
                    if (popup.getSubElements().length > 0) {
                        popup.setVisible(true);
                    }
                }
            });
            pm.add(mi);
        }
        MenuScroller.setScrollerFor(pm);
        return pm;
    }

    private boolean updateUserFeedback(MouseEvent e) {
        ArrayList<OsmPrimitive> toHighlight = new ArrayList<OsmPrimitive>(2);
        Optional<OsmPrimitive> pHovered = SplitMode.getPrimitiveAtPoint(e.getPoint());
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (pHovered.filter(Node.class::isInstance).isPresent()) {
            ArrayList<Way> selectedWays;
            Node nHovered = (Node)pHovered.get();
            List<Way> applicableWays = SplitMode.getApplicableWays(nHovered, selectedWays = ds != null ? new ArrayList<Way>(ds.getSelectedWays()) : null);
            if (!applicableWays.isEmpty()) {
                pHovered.ifPresent(toHighlight::add);
            }
            if (applicableWays.size() == 1) {
                toHighlight.add(applicableWays.get(0));
            }
        }
        return this.highlight.highlightOnly(toHighlight);
    }

    private boolean removeHighlighting() {
        boolean anyHighlighted = this.highlight.anyHighlighted();
        this.highlight.clear();
        return anyHighlighted;
    }

    private void addHoverHighlightListener(Component c, final Collection<OsmPrimitive> prims) {
        c.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ SplitMode this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (this.this$0.highlight.highlightOnly(prims)) {
                    MainApplication.getMap().mapView.repaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (this.this$0.removeHighlighting()) {
                    MainApplication.getMap().mapView.repaint();
                }
            }
        });
    }

    private static String createLabelText(OsmPrimitive primitive) {
        return SplitMode.createLabelText(primitive, true);
    }

    private static String createLabelText(OsmPrimitive primitive, boolean includeKeys) {
        StringBuilder text = new StringBuilder(32);
        Object name = Utils.escapeReservedCharactersHTML(primitive.getDisplayName(DefaultNameFormatter.getInstance()));
        if (primitive.isNewOrUndeleted() || primitive.isModified()) {
            name = "<i><b>" + (String)name + "*</b></i>";
        }
        text.append((String)name);
        if (!primitive.isNew()) {
            text.append(" [id=").append(primitive.getId()).append(']');
        }
        if (primitive.getUser() != null) {
            text.append(" [").append(I18n.tr("User:", new Object[0])).append(' ').append(Utils.escapeReservedCharactersHTML(primitive.getUser().getName())).append(']');
        }
        if (includeKeys) {
            primitive.visitKeys((p, key, value) -> text.append("<br>").append(key).append('=').append(value));
        }
        return text.toString();
    }

    private static class SplitWayActionConcrete
    extends AbstractAction {
        private final Way splitWay;
        private final List<Node> splitNodes;
        private final List<OsmPrimitive> selection;

        SplitWayActionConcrete(Way splitWay, List<Node> splitNodes, List<OsmPrimitive> selection) {
            super(I18n.tr("Split way {0}", DefaultNameFormatter.getInstance().format(splitWay)), ImageProvider.get(splitWay.getType()));
            this.putValue("ShortDescription", this.getValue("Name"));
            this.splitWay = splitWay;
            this.splitNodes = splitNodes;
            this.selection = selection;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SplitWayAction.doSplitWayShowSegmentSelection(this.splitWay, this.splitNodes, this.selection);
            if (this.splitWay.getDataSet().selectionEmpty()) {
                this.splitWay.getDataSet().setSelected(this.splitWay);
            }
        }

        @Override
        public boolean isEnabled() {
            return !this.splitWay.getDataSet().isLocked();
        }
    }
}

