/* adept_arrays.h -- Header file for array functionality of Adept automatic differentiation library

    Copyright (C) 2014-2015 European Centre for Medium-Range Weather Forecasts

    Author: Robin Hogan <r.j.hogan@ecmwf.int>

    This file is part of the Adept library.

*/

#ifndef AdeptArrays_H
#define AdeptArrays_H 1

#include <adept.h>

#include <adept/Array.h>
#include <adept/FixedArray.h>
#include <adept/reduce.h>
#include <adept/matmul.h>
#include <adept/solve.h>
#include <adept/inv.h>
#include <adept/Allocator.h>
#include <adept/interp.h>
#include <adept/spread.h>
#include <adept/outer_product.h>
#include <adept/eval.h>
#include <adept/array_shortcuts.h>
#include <adept/vector_utilities.h>

#endif
