/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core;

import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stax.StAXSource;
import javax.xml.xquery.XQDataFactory;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQSequence;
import javax.xml.xquery.XQSequenceType;
import javax.xml.xquery.XQStaticContext;
import net.xqj.core.GenericXQConnection;
import net.xqj.core.XQToolkit;
import net.xqj.core.exception.XQExceptionImpl;
import net.xqj.core.util.Logger;
import net.xqj.core.xqitem.AtomicXQItem;
import net.xqj.core.xqitem.LexicalValidator;
import net.xqj.core.xqitem.ObjectToXQItemConverter;
import net.xqj.core.xqitem.XQItemBase;
import net.xqj.core.xqitem.XQItemFactory;
import net.xqj.core.xqitem.XQItemProxy;
import net.xqj.core.xqitemtype.XQItemTypeFactory;
import net.xqj.core.xqsequence.XQSequenceFactory;
import net.xqj.core.xqsequence.XQSequenceProxy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XQDataFactoryImpl
implements XQDataFactory,
Cloneable {
    public XQItem createItemFromAtomicValue(String value, XQItemType type) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(85, this, value, type);
        XQToolkit.nullValueTest(value, "value", "XQJDF002");
        if (type == null || type.getItemKind() != 1) {
            throw new XQExceptionImpl("Must provide a XQItemType with an item kind of XQITEMKIND_ATOMIC.", "XQJDF003");
        }
        LexicalValidator.validate(value, type);
        XQItemProxy proxy = XQItemFactory.newXQItemProxy(XQItemFactory.newAtomicXQItem(value));
        proxy.setItemType(type);
        return proxy;
    }

    public XQItem createItemFromString(String value, XQItemType type) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(4, 86, this, value, type);
        if (type == null) {
            type = XQItemTypeFactory.createAtomicType(29);
        }
        if (!XQToolkit.isDerivedFromRestriction(XQItemTypeFactory.createAtomicType(29), type)) {
            throw new XQExceptionImpl("XQItemType (" + String.valueOf(type) + ") is not derived from xs:string.", "XQJDF004");
        }
        XQToolkit.nullValueTest(value, "value", "XQJDF006");
        LexicalValidator.validate(value, type);
        XQItemProxy proxy = XQItemFactory.newXQItemProxy(XQItemFactory.newAtomicXQItem(value));
        proxy.setItemType(type);
        return proxy;
    }

    public XQItem createItemFromDocument(String value, String baseURI, XQItemType type) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(87, this, value, baseURI, type);
        XQToolkit.nullValueTest(value, "value", "XQJDF008");
        if (type == null) {
            type = XQItemTypeFactory.createDocumentElementType(XQItemTypeFactory.createElementType(null, 1));
        } else if (type.getItemKind() != 5 && type.getItemKind() != 6) {
            throw new XQExceptionImpl("XQItemType must be XQITEMKIND_DOCUMENT_ELEMENT or XQITEMKIND_DOCUMENT_SCHEMA_ELEMENT.", "XQJDF009");
        }
        XQItemProxy proxy = XQItemFactory.newXQItemProxy(XQItemFactory.newDocumentXQItem(XQItemFactory.newMemoryXMLXQItem(value, baseURI, true), true));
        proxy.setItemType(type);
        return proxy;
    }

    public XQItem createItemFromDocument(Reader value, String baseURI, XQItemType type) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(88, this, value, baseURI, type);
        XQToolkit.nullValueTest(value, "value", "XQJDF011");
        if (type == null) {
            type = XQItemTypeFactory.createDocumentElementType(XQItemTypeFactory.createElementType(null, 1));
        } else if (type.getItemKind() != 5 && type.getItemKind() != 6) {
            throw new XQExceptionImpl("XQItemType must be XQITEMKIND_DOCUMENT_ELEMENT or XQITEMKIND_DOCUMENT_SCHEMA_ELEMENT.", "XQJDF012");
        }
        XQItemProxy proxy = XQItemFactory.newXQItemProxy(XQItemFactory.newDocumentXQItem(XQItemFactory.newMemoryXMLXQItem(value, baseURI, true), true));
        proxy.setItemType(type);
        return proxy;
    }

    public XQItem createItemFromDocument(InputStream value, String baseURI, XQItemType type) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(89, this, value, baseURI, type);
        XQToolkit.nullValueTest(value, "value", "XQJDF014");
        if (type == null) {
            type = XQItemTypeFactory.createDocumentElementType(XQItemTypeFactory.createElementType(null, 1));
        } else if (type.getItemKind() != 5 && type.getItemKind() != 6) {
            throw new XQExceptionImpl("XQItemType must be XQITEMKIND_DOCUMENT_ELEMENT or XQITEMKIND_DOCUMENT_SCHEMA_ELEMENT.", "XQJDF015");
        }
        XQItemProxy proxy = XQItemFactory.newXQItemProxy(XQItemFactory.newDocumentXQItem(XQItemFactory.newMemoryXMLXQItem(value, baseURI, true), true));
        proxy.setItemType(type);
        return proxy;
    }

    public XQItem createItemFromDocument(XMLStreamReader value, XQItemType type) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(90, this, value, type);
        XQToolkit.nullValueTest(value, "value", "XQJDF005");
        if (type == null) {
            type = this.createDocumentElementType(this.createElementType(null, 1));
        } else if (type.getItemKind() != 5 && type.getItemKind() != 6) {
            throw new XQException("XQItemType is invalid.");
        }
        return this.createItemFromDocument(new StAXSource(value), type);
    }

    public XQItem createItemFromDocument(Source value, XQItemType type) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(92, this, value, type);
        XQToolkit.nullValueTest(value, "value", "XQJDF007");
        if (type == null) {
            type = XQItemTypeFactory.createDocumentElementType(XQItemTypeFactory.createElementType(null, 1));
        }
        switch (this.getStaticContext().getBindingMode()) {
            case 0: {
                XQItemProxy itemProxy = XQItemFactory.newXQItemProxy(XQItemFactory.newMemoryXMLXQItem(value));
                itemProxy.setItemType(type);
                return itemProxy;
            }
            case 1: {
                throw new RuntimeException("Fix me.");
            }
        }
        throw new RuntimeException("Fix me.");
    }

    public XQItem createItemFromObject(Object value, XQItemType type) throws XQException {
        this.checkIfClosed();
        XQToolkit.nullValueTest(value, "value", "XQJDF010");
        this.getLogger().debug(93, this, value.getClass().getName(), value, type);
        if (value instanceof String && type != null) {
            LexicalValidator.validate((String)value, type);
        }
        XQItemProxy proxy = XQItemFactory.newXQItemProxy(ObjectToXQItemConverter.createXQItem(value, type));
        return proxy;
    }

    public XQItem createItemFromBoolean(boolean value, XQItemType type) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(94, this, value, type);
        if (type == null) {
            type = XQItemTypeFactory.createAtomicType(10);
        }
        XQItemBase item = type.getItemKind() == 1 && type.getBaseType() == 10 ? XQItemFactory.newAtomicXQItem(Boolean.toString(value)) : ObjectToXQItemConverter.createXQItem(value, type);
        item.setItemType(type);
        XQItemProxy proxy = XQItemFactory.newXQItemProxy(item);
        return proxy;
    }

    public XQItem createItemFromByte(byte value, XQItemType type) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(95, this, value, type);
        if (type == null) {
            type = XQItemTypeFactory.createAtomicType(31);
        }
        String stringValue = Byte.toString(value);
        LexicalValidator.validate(stringValue, type);
        XQItemBase item = XQToolkit.isDerivedFromRestriction(XQItemTypeFactory.createAtomicType(31), type) ? XQItemFactory.newAtomicXQItem(stringValue) : ObjectToXQItemConverter.createXQItem(stringValue, type);
        item.setItemType(type);
        XQItemProxy proxy = XQItemFactory.newXQItemProxy(item);
        return proxy;
    }

    public XQItem createItemFromDouble(double value, XQItemType type) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(96, this, value, type);
        if (type == null) {
            type = XQItemTypeFactory.createAtomicType(18);
        }
        String stringValue = Double.toString(value);
        LexicalValidator.validate(stringValue, type);
        XQItemBase item = XQToolkit.isDerivedFromRestriction(XQItemTypeFactory.createAtomicType(18), type) ? XQItemFactory.newAtomicXQItem(stringValue) : ObjectToXQItemConverter.createXQItem(stringValue, type);
        item.setItemType(type);
        XQItemProxy proxy = XQItemFactory.newXQItemProxy(item);
        return proxy;
    }

    public XQItem createItemFromFloat(float value, XQItemType type) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(97, this, Float.valueOf(value), type);
        if (type == null) {
            type = XQItemTypeFactory.createAtomicType(20);
        }
        String stringValue = Float.toString(value);
        LexicalValidator.validate(stringValue, type);
        XQItemBase item = XQToolkit.isDerivedFromRestriction(XQItemTypeFactory.createAtomicType(20), type) ? XQItemFactory.newAtomicXQItem(stringValue) : ObjectToXQItemConverter.createXQItem(stringValue, type);
        item.setItemType(type);
        XQItemProxy proxy = XQItemFactory.newXQItemProxy(item);
        return proxy;
    }

    public XQItem createItemFromInt(int value, XQItemType type) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(98, this, value, type);
        if (type == null) {
            type = XQItemTypeFactory.createAtomicType(12);
        }
        String stringValue = Integer.toString(value);
        LexicalValidator.validate(stringValue, type);
        XQItemBase item = XQToolkit.isDerivedFromRestriction(XQItemTypeFactory.createAtomicType(12), type) ? XQItemFactory.newAtomicXQItem(stringValue) : ObjectToXQItemConverter.createXQItem(stringValue, type);
        item.setItemType(type);
        XQItemProxy proxy = XQItemFactory.newXQItemProxy(item);
        return proxy;
    }

    public XQItem createItemFromLong(long value, XQItemType type) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(99, this, value, type);
        if (type == null) {
            type = XQItemTypeFactory.createAtomicType(15);
        }
        String stringValue = Long.toString(value);
        LexicalValidator.validate(stringValue, type);
        XQItemBase item = XQToolkit.isDerivedFromRestriction(XQItemTypeFactory.createAtomicType(15), type) ? XQItemFactory.newAtomicXQItem(stringValue) : ObjectToXQItemConverter.createXQItem(stringValue, type);
        item.setItemType(type);
        XQItemProxy proxy = XQItemFactory.newXQItemProxy(item);
        return proxy;
    }

    public XQItem createItemFromNode(Node value, XQItemType type) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(100, this, value, type);
        XQToolkit.nullValueTest(value, "value", "XQJDF013");
        String namespace = null;
        if (type == null) {
            String prefix = value.getPrefix();
            String local = value.getLocalName();
            namespace = value.getNamespaceURI();
            switch (value.getNodeType()) {
                case 1: {
                    type = XQItemTypeFactory.createElementType(XQToolkit.getQName(prefix, local, namespace), 5);
                    break;
                }
                case 2: {
                    type = XQItemTypeFactory.createAttributeType(XQToolkit.getQName(prefix, local, namespace), 5);
                    break;
                }
                case 9: {
                    Element rootValue = ((Document)value).getDocumentElement();
                    prefix = rootValue.getPrefix();
                    local = rootValue.getLocalName();
                    namespace = rootValue.getNamespaceURI();
                    type = XQItemTypeFactory.createDocumentElementType(XQItemTypeFactory.createElementType(XQToolkit.getQName(prefix, local, namespace), 2));
                    break;
                }
                case 11: {
                    type = XQItemTypeFactory.createDocumentType();
                    break;
                }
                case 8: {
                    type = XQItemTypeFactory.createCommentType();
                    break;
                }
                case 7: {
                    type = XQItemTypeFactory.createProcessingInstructionType(value.getNodeName());
                    break;
                }
                case 3: {
                    type = XQItemTypeFactory.createTextType();
                    break;
                }
                case 4: {
                    throw new XQException("There is no equivilant XQItemType for a CDATA node. Not supported.");
                }
                case 6: {
                    throw new XQException("Entity Node not supported.");
                }
                case 5: {
                    throw new XQException("Entity Reference Node not supported.");
                }
                case 12: {
                    throw new XQException("Notation Node not supported.");
                }
                case 10: {
                    throw new XQException("There is no equivilant XQItemType for a DOCTYPE node. Not supported.");
                }
            }
        }
        switch (type.getItemKind()) {
            case 7: {
                if (value.getNodeType() == 1) break;
                throw new XQException("XQItemType is XQITEMKIND_ELEMENT but Node type is not ELEMENT_NODE.");
            }
            case 5: {
                if (value.getNodeType() == 9) break;
                throw new XQException("XQItemType is DOCUMENT_ELEMENT but Node type is not DOCUMENT_NODE.");
            }
            case 2: {
                if (value.getNodeType() == 2) break;
                throw new XQException("XQItemType is XQITEMKIND_ATTRIBUTE but Node type is not ATTRIBUTE_NODE.");
            }
            case 3: {
                if (value.getNodeType() == 8) break;
                throw new XQException("XQItemType is XQITEMKIND_COMMENT but Node type is not COMMENT_NODE.");
            }
            case 4: {
                if (value.getNodeType() == 11) break;
                throw new XQException("XQItemType is XQITEMKIND_DOCUMENT but Node type is not DOCUMENT_FRAGMENT_NODE.");
            }
            case 10: {
                if (value.getNodeType() == 7) break;
                throw new XQException("XQItemType is XQITEMKIND_PI but Node type is not PROCESSING_INSTRUCTION_NODE.");
            }
            case 11: {
                if (value.getNodeType() == 3) break;
                throw new XQException("XQItemType is XQITEMKIND_TEXT but Node type is not TEXT_NODE.");
            }
            case 1: {
                throw new XQException("Atomic XQItemType kind not supported.");
            }
        }
        XQItemBase itemBase = ObjectToXQItemConverter.createXQItem(value, type);
        XQItemProxy proxy = XQItemFactory.newXQItemProxy(itemBase);
        proxy.setNodeUri(namespace);
        return proxy;
    }

    public XQItem createItemFromShort(short value, XQItemType type) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(101, this, value, type);
        String stringValue = Short.toString(value);
        AtomicXQItem base = XQItemFactory.newAtomicXQItem(stringValue.toCharArray());
        if (type == null) {
            type = XQItemTypeFactory.createAtomicType(14);
        }
        LexicalValidator.validate(stringValue, type);
        if (type.getItemKind() != 1) {
            throw new XQExceptionImpl("cannot cast to " + String.valueOf(type), "XQJDF021");
        }
        XQItemProxy proxy = XQItemFactory.newXQItemProxy(base);
        proxy.setItemType(type);
        return proxy;
    }

    public XQItem createItem(XQItem item) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(102, this, item);
        XQToolkit.nullValueTest(item, "item", "XQJDF016");
        if (item.isClosed()) {
            throw new XQExceptionImpl("Can not create a copy of a closed XQItem.", "XQJDF022");
        }
        return XQItemFactory.newXQItemProxy(ObjectToXQItemConverter.createXQItem(item, item.getItemType()));
    }

    public XQSequence createSequence(XQSequence s) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(103, this, s);
        XQToolkit.nullValueTest(s, "sequence", "XQJDF001");
        if (s.isClosed()) {
            throw new XQExceptionImpl("Can not create a new XQSequence object from from a XQSequence object which is closed.", "XQJDF003");
        }
        XQSequenceProxy proxy = XQSequenceFactory.newXQSequenceProxy(XQSequenceFactory.newScrollableXQSequence(s));
        return proxy;
    }

    public XQSequence createSequence(Iterator iterator) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(104, this, iterator);
        XQToolkit.nullValueTest(iterator, "sequence", "XQJDF017");
        ArrayList<XQItemBase> list = new ArrayList<XQItemBase>();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj == null) continue;
            if (obj instanceof XQItemBase) {
                list.add((XQItemBase)obj);
                continue;
            }
            if (obj instanceof XQSequence) {
                XQSequence s = (XQSequence)obj;
                if (s.isOnItem()) {
                    list.add(ObjectToXQItemConverter.createXQItem(s.getItem(), null));
                }
                while (s.next()) {
                    list.add(ObjectToXQItemConverter.createXQItem(s.getItem(), null));
                }
                continue;
            }
            list.add(ObjectToXQItemConverter.createXQItem(obj, null));
        }
        return XQSequenceFactory.newXQSequenceProxy(XQSequenceFactory.newScrollableXQSequence(list));
    }

    public XQItemType createAtomicType(int basetype) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(105, this, basetype);
        if (basetype == 1 || basetype == 2 || basetype == 49 || basetype == 51 || basetype == 50 || basetype == 3) {
            throw new XQExceptionImpl("passed an invalid basetype value.", "XQJDF023");
        }
        return XQItemTypeFactory.createAtomicType(basetype);
    }

    public XQItemType createAtomicType(int basetype, QName typename, URI schemaURI) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(106, this, basetype, typename, schemaURI);
        if (basetype == 1 || basetype == 2 || basetype == 49 || basetype == 51 || basetype == 50 || basetype == 3) {
            throw new XQExceptionImpl("passed an invalid basetype value.", "XQJDF024");
        }
        return XQItemTypeFactory.createAtomicType(basetype, typename, schemaURI);
    }

    public XQItemType createAttributeType(QName nodename, int basetype) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(107, this, nodename, basetype);
        if (basetype == 1 || basetype == 2) {
            throw new XQExceptionImpl("Invalid basetype parameter given.", "XQJDF025");
        }
        return XQItemTypeFactory.createAttributeType(nodename, basetype);
    }

    public XQItemType createAttributeType(QName nodename, int basetype, QName typename, URI schemaURI) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(108, this, nodename, basetype, typename, schemaURI);
        if (basetype == 1 || basetype == 2) {
            throw new XQExceptionImpl("Invalid basetype parameter given.", "XQJDF026");
        }
        if (schemaURI != null && typename == null) {
            throw new XQExceptionImpl("schemaURI is specified but typename is not.", "XQJDF027");
        }
        return XQItemTypeFactory.createAttributeType(nodename, basetype, typename, schemaURI);
    }

    public XQItemType createSchemaAttributeType(QName nodename, int basetype, URI schemaURI) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(109, this, nodename, basetype, schemaURI);
        if (basetype == 1 || basetype == 2) {
            throw new XQExceptionImpl("Invalid basetype parameter given.", "XQJDF028");
        }
        if (nodename == null) {
            throw new XQExceptionImpl("nodename value is null.", "XQJDF029");
        }
        return XQItemTypeFactory.createSchemaAttributeType(nodename, basetype, schemaURI);
    }

    public XQItemType createCommentType() throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(110, this);
        return XQItemTypeFactory.createCommentType();
    }

    public XQItemType createDocumentElementType(XQItemType elementType) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(111, this, elementType);
        XQToolkit.nullValueTest(elementType, "elementType", "XQJDF018");
        if (elementType.getItemKind() != 7) {
            throw new XQExceptionImpl("The XQItemType is not of type XQITEMKIND_ELEMENT.", "XQJDF030");
        }
        return XQItemTypeFactory.createDocumentElementType(elementType);
    }

    public XQItemType createDocumentSchemaElementType(XQItemType elementType) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(112, this, elementType);
        return XQItemTypeFactory.createDocumentSchemaElementType(elementType);
    }

    public XQItemType createDocumentType() throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(113, this);
        return XQItemTypeFactory.createDocumentType();
    }

    public XQItemType createElementType(QName nodename, int basetype) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(114, this, nodename, basetype);
        return XQItemTypeFactory.createElementType(nodename, basetype);
    }

    public XQItemType createElementType(QName nodename, int basetype, QName typename, URI schemaURI, boolean allowNill) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(115, this, nodename, basetype, typename, schemaURI, allowNill);
        if (schemaURI != null && typename == null) {
            throw new XQExceptionImpl("schemaURI is specified but typename is not.", "XQJDF019");
        }
        return XQItemTypeFactory.createElementType(nodename, basetype, typename, schemaURI, allowNill);
    }

    public XQItemType createSchemaElementType(QName nodename, int basetype, URI schemaURI) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(116, this, nodename, basetype, schemaURI);
        XQToolkit.nullValueTest(nodename, "nodename", "XQJDF020");
        return XQItemTypeFactory.createSchemaElementType(nodename, basetype, schemaURI);
    }

    public XQItemType createItemType() throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(4, 117, this);
        return XQItemTypeFactory.createItemType();
    }

    public XQItemType createNodeType() throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(118, this);
        return XQItemTypeFactory.createNodeType();
    }

    public XQItemType createProcessingInstructionType(String piTarget) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(119, this);
        return XQItemTypeFactory.createProcessingInstructionType(piTarget);
    }

    public XQSequenceType createSequenceType(XQItemType item, int occurrence) throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(120, this, item, occurrence);
        switch (occurrence) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new XQExceptionImpl("Invalid occurrence value.", "XQJDF031");
            }
        }
        if (item != null && occurrence == 5) {
            throw new XQExceptionImpl("item value is not null but occurrence value is OCC_EMPTY.", "XQJDF032");
        }
        if (item == null && occurrence != 5) {
            throw new XQExceptionImpl("item value is null but occurrence value is not OCC_EMPTY.", "XQJDF033");
        }
        return XQItemTypeFactory.createSequenceType(item, occurrence);
    }

    public XQItemType createTextType() throws XQException {
        this.checkIfClosed();
        this.getLogger().debug(121, this);
        return XQItemTypeFactory.createTextType();
    }

    public abstract XQStaticContext getStaticContext() throws XQException;

    public abstract GenericXQConnection getUnderlyingConnection();

    public abstract boolean isClosed();

    public abstract void checkIfClosed() throws XQException;

    protected Logger getLogger() throws XQException {
        return this.getUnderlyingConnection().getDataSource().getLogger();
    }

    public Object clone() {
        try {
            return (XQDataFactoryImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

