/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.basex.core.Text;
import org.basex.gui.GUICommand;
import org.basex.gui.GUIMenuCmd;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXImages;
import org.basex.util.Prop;
import org.basex.util.hash.IntSet;
import org.basex.util.list.StringList;

public final class GUIConstants {
    public static final String MAPVIEW = "map";
    public static final String FOLDERVIEW = "folder";
    public static final String TEXTVIEW = "text";
    public static final String TABLEVIEW = "table";
    public static final String INFOVIEW = "info";
    public static final String EXPLOREVIEW = "explore";
    public static final String PLOTVIEW = "plot";
    public static final String TREEVIEW = "tree";
    public static final String EDITORVIEW = "editor";
    public static final String VIEWS = "V H editor folder map plot  - H text info table tree explore - -";
    static final GUIMenuCmd[] TOOLBAR = new GUIMenuCmd[]{GUIMenuCmd.C_CREATE, GUIMenuCmd.C_OPEN_MANAGE, GUIMenuCmd.C_PROPERTIES, GUIMenuCmd.C_CLOSE, null, GUIMenuCmd.C_SHOW_EDITOR, GUIMenuCmd.C_SHOW_RESULT, GUIMenuCmd.C_INDENT_RESULT, GUIMenuCmd.C_SHOW_INFO, null, GUIMenuCmd.C_SHOW_MAP, GUIMenuCmd.C_SHOW_TREE, GUIMenuCmd.C_SHOW_FOLDER, GUIMenuCmd.C_SHOW_PLOT, GUIMenuCmd.C_SHOW_TABLE, GUIMenuCmd.C_SHOW_EXPLORE, null, GUIMenuCmd.C_GO_HOME, GUIMenuCmd.C_GO_BACK, GUIMenuCmd.C_GO_UP, GUIMenuCmd.C_GO_FORWARD, GUIMenuCmd.C_FILTER_NODES, null, GUIMenuCmd.C_PREFERENCES};
    static final String[] MENUBAR = new String[]{Text.DATABASE, Text.EDITOR, Text.VIEW, Text.VISUALIZATION, Text.OPTIONS, Text.HELP};
    static final GUICommand[][] MENUITEMS = new GUICommand[][]{{GUIMenuCmd.C_CREATE, GUIMenuCmd.C_OPEN_MANAGE, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_PROPERTIES, GUIMenuCmd.C_EXPORT, GUIMenuCmd.C_CLOSE, Prop.MAC ? null : GUIMenuCmd.SEPARATOR, Prop.MAC ? null : GUIMenuCmd.C_EXIT}, {GUIMenuCmd.C_EDIT_NEW, GUIMenuCmd.C_EDIT_OPEN, GUIMenuCmd.C_EDIT_REOPEN, GUIMenuCmd.C_EDIT_SAVE, GUIMenuCmd.C_EDIT_SAVE_AS, GUIMenuCmd.C_EDIT_CLOSE, GUIMenuCmd.C_EDIT_CLOSE_ALL, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_GO, GUIMenuCmd.C_STOP, GUIMenuCmd.C_INDENT_RESULT, GUIMenuCmd.C_EXTERNAL_VARIABLES, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_FORMAT, GUIMenuCmd.C_COMMENT, GUIMenuCmd.C_SORT, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_LOWER_CASE, GUIMenuCmd.C_UPPER_CASE, GUIMenuCmd.C_TITLE_CASE, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_JUMP_TO_BRACKET, GUIMenuCmd.C_JUMP_TO_FILE, GUIMenuCmd.C_NEXT_ERROR, GUIMenuCmd.SEPARATOR}, {GUIMenuCmd.C_SHOW_EDITOR, GUIMenuCmd.C_SHOW_PROJECT, GUIMenuCmd.C_FIND_CONTENTS, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_SHOW_RESULT, GUIMenuCmd.C_SHOW_INFO, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_SHOW_BUTTONS, GUIMenuCmd.C_SHOW_INPUT_BAR, GUIMenuCmd.C_SHOW_STATUS_BAR, Prop.MAC ? null : GUIMenuCmd.C_FULLSCREEN}, {GUIMenuCmd.C_SHOW_MAP, GUIMenuCmd.C_SHOW_TREE, GUIMenuCmd.C_SHOW_FOLDER, GUIMenuCmd.C_SHOW_PLOT, GUIMenuCmd.C_SHOW_TABLE, GUIMenuCmd.C_SHOW_EXPLORE}, {GUIMenuCmd.C_INDENT_RESULT, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_RT_EXECUTION, GUIMenuCmd.C_RT_FILTERING, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_PACKAGES, Prop.MAC ? null : GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_COLOR, GUIMenuCmd.C_FONTS, Prop.MAC ? null : GUIMenuCmd.C_PREFERENCES}, {GUIMenuCmd.C_HELP, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_COMMUNITY, GUIMenuCmd.C_CHECK_FOR_UPDATES, GUIMenuCmd.SEPARATOR, GUIMenuCmd.C_SHOW_MEM, Prop.MAC ? null : GUIMenuCmd.C_ABOUT}};
    public static final GUIMenuCmd[] POPUP = new GUIMenuCmd[]{GUIMenuCmd.C_GO_BACK, GUIMenuCmd.C_GO_UP, GUIMenuCmd.C_GO_FORWARD, GUIMenuCmd.C_FILTER_NODES, null, GUIMenuCmd.C_COPY_NODES, GUIMenuCmd.C_PASTE_NODES, GUIMenuCmd.C_DELETE_NODES, GUIMenuCmd.C_NEW_NODES, GUIMenuCmd.C_EDIT_NODES, null, GUIMenuCmd.C_COPY_PATH};
    public static final Cursor CURSORARROW = new Cursor(0);
    public static final Cursor CURSORHAND = new Cursor(12);
    public static final Cursor CURSORWAIT = new Cursor(3);
    public static final Cursor CURSORMOVEH = new Cursor(11);
    public static final Cursor CURSORMOVEV = new Cursor(8);
    public static final Cursor CURSORTEXT = new Cursor(2);
    public static final Cursor CURSORMOVE = new Cursor(13);
    private static final JTextField TEXTFIELD = new JTextField();
    private static final JLabel LABEL = new JLabel();
    public static final Color BACK = new Color(TEXTFIELD.getBackground().getRGB());
    public static final Color TEXT = new Color(TEXTFIELD.getForeground().getRGB());
    public static final Color PANEL = new Color(LABEL.getBackground().getRGB());
    private static final boolean INVERT = BACK.getRed() + BACK.getGreen() + BACK.getBlue() < 384;
    public static final Color RED = GUIConstants.color(224, 0, 0);
    public static final Color LRED = GUIConstants.color(255, 216, 216);
    public static final Color GREEN = GUIConstants.color(32, 160, 32);
    public static final Color BLUE = GUIConstants.color(32, 96, 192);
    public static final Color PURPLE = GUIConstants.color(160, 32, 160);
    public static final Color GRAY = GUIConstants.color(0, 160, 160);
    public static final Color DGRAY = GUIConstants.color(112, 112, 112);
    public static Color lgray;
    public static Color gray;
    public static Color mgray;
    public static Color dgray;
    private static final Color[] COLORS;
    public static Color color1;
    public static Color color2;
    public static Color color3;
    public static Color color4;
    public static Color colormark1;
    public static Color colormark2;
    public static Color colormark3;
    public static Color colormark4;
    public static Color color1A;
    public static Color color2A;
    public static Color color3A;
    public static Color colormark1A;
    public static Color colormark2A;
    public static final String MONOFONT;
    public static Font font;
    public static Font bfont;
    public static Font mfont;
    public static Font dmfont;
    public static int fontSize;
    private static String[] fonts;
    private static final char[] MONOSPACE;
    public static final int NO_MOD = 0;
    public static final int SHIFT = 64;
    public static final int ALT = 512;
    public static final int CTRL = 128;
    public static final int META;

    public static String[] fonts() {
        if (fonts == null) {
            StringList list = new StringList();
            for (String name : GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                boolean add = true;
                Font f = new Font(name, 0, 100);
                for (char ch : MONOSPACE) {
                    if (f.canDisplay(ch)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                list.add(name);
            }
            fonts = (String[])list.finish();
        }
        return fonts;
    }

    public static String[] monoFonts() {
        StringList monos = new StringList();
        for (String name : GUIConstants.fonts()) {
            if (!GUIConstants.isMono(LABEL.getFontMetrics(new Font(name, 0, 100)))) continue;
            monos.add(name);
        }
        return (String[])monos.finish();
    }

    public static boolean isMono(FontMetrics fm) {
        IntSet set = new IntSet(4L);
        for (char ch : MONOSPACE) {
            int w = fm.charWidth(ch);
            if (w != 0 && (!set.add(w) || set.size() <= 2)) continue;
            return false;
        }
        return true;
    }

    private GUIConstants() {
    }

    public static synchronized void init(GUIOptions opts) {
        lgray = GUIConstants.color(224, 224, 224);
        gray = GUIConstants.color(160, 160, 160);
        mgray = GUIConstants.color(128, 128, 128);
        dgray = GUIConstants.color(64, 64, 64);
        int r = opts.get(GUIOptions.COLORRED);
        int g = opts.get(GUIOptions.COLORGREEN);
        int b = opts.get(GUIOptions.COLORBLUE);
        int cl = COLORS.length;
        for (int c = 1; c < cl + 1; ++c) {
            GUIConstants.COLORS[c - 1] = GUIConstants.color(Math.max(255 - c * r, 0), Math.max(255 - c * g, 0), Math.max(255 - c * b, 0));
        }
        color1 = GUIConstants.color(GUIConstants.darker(r, 24), GUIConstants.darker(g, 25), GUIConstants.darker(b, 40));
        color2 = GUIConstants.color(GUIConstants.darker(r, 32), GUIConstants.darker(g, 32), GUIConstants.darker(b, 44));
        color3 = GUIConstants.color(GUIConstants.darker(r, 48), GUIConstants.darker(g, 50), GUIConstants.darker(b, 40));
        color4 = GUIConstants.color(GUIConstants.darker(r, 140), GUIConstants.darker(g, 100), GUIConstants.darker(b, 70));
        colormark1 = GUIConstants.color(GUIConstants.darker(r, 16), GUIConstants.darker(g, 120), GUIConstants.darker(b, 240));
        colormark2 = GUIConstants.color(GUIConstants.darker(r, 16), GUIConstants.darker(g, 80), GUIConstants.darker(b, 160));
        colormark3 = GUIConstants.color(GUIConstants.darker(r, 32), GUIConstants.darker(g, 160), GUIConstants.darker(b, 320));
        colormark4 = GUIConstants.color(GUIConstants.darker(r, 1), GUIConstants.darker(g, 40), GUIConstants.darker(b, 80));
        Color col = COLORS[16];
        color1A = GUIConstants.color(GUIConstants.darker(r, 110), GUIConstants.darker(g, 150), GUIConstants.darker(b, 160), 100);
        color2A = GUIConstants.color(col.getRed(), col.getGreen(), col.getBlue(), 50);
        color3A = GUIConstants.color(col.getRed(), col.getGreen(), col.getBlue(), 30);
        colormark1A = GUIConstants.color(GUIConstants.darker(r, 32), GUIConstants.darker(g, 160), GUIConstants.darker(b, 320), 100);
        colormark2A = GUIConstants.color(GUIConstants.darker(r, 12), GUIConstants.darker(g, 60), GUIConstants.darker(b, 120), 100);
        String name = opts.get(GUIOptions.FONT);
        fontSize = opts.get(GUIOptions.FONTSIZE);
        font = new Font(name, 0, fontSize);
        mfont = new Font(opts.get(GUIOptions.MONOFONT), 0, fontSize);
        bfont = new Font(name, 1, fontSize);
        dmfont = new Font(opts.get(GUIOptions.MONOFONT), 0, LABEL.getFont().getSize());
    }

    public static Color color(int i) {
        return COLORS[Math.min(COLORS.length - 1, i)];
    }

    private static int darker(int c, int f) {
        return Math.max(0, 255 - c * f / 10);
    }

    private static Color color(int r, int g, int b) {
        return INVERT ? new Color(255 - r, 255 - g, 255 - b) : new Color(r, g, b);
    }

    private static Color color(int r, int g, int b, int a) {
        return INVERT ? new Color(255 - r, 255 - g, 255 - b, 255 - a) : new Color(r, g, b, a);
    }

    static {
        COLORS = new Color[100];
        MONOFONT = Prop.WIN ? "Consolas" : "Monospaced";
        MONOSPACE = " !,-.01:<ILMWilmw".toCharArray();
        META = Prop.MAC ? 256 : 128;
    }

    public static enum Msg {
        WARN("warn", "warning"),
        ERROR("error", "error"),
        SUCCESS("ok", "information"),
        QUESTION("warn", "question"),
        YESNOCANCEL("warn", "question");

        public final Icon small;
        public final Icon large;

        private Msg(String s, String l) {
            this.small = BaseXImages.icon(s);
            this.large = UIManager.getIcon("OptionPane." + l + "Icon");
        }
    }
}

