/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.inspect;

import org.basex.io.IOContent;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.inspect.Inspect;
import org.basex.query.scope.AModule;
import org.basex.query.scope.LibraryModule;
import org.basex.query.scope.StaticScope;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.StaticVar;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenObjectMap;
import org.basex.util.list.TokenList;

final class PlainDoc
extends Inspect {
    PlainDoc(QueryContext qc, InputInfo info) {
        super(qc, info);
    }

    FNode context() throws QueryException {
        FBuilder root = this.element("context");
        for (StaticVar sv : this.qc.vars) {
            root.add(this.variable(sv));
        }
        for (StaticFunc sf : this.qc.functions.funcs()) {
            root.add(this.function(sf.name, sf, sf.funcType(), sf.anns));
        }
        return root.finish();
    }

    @Override
    public FNode parse(IOContent source) throws QueryException {
        TokenObjectMap<TokenList> doc;
        AModule module = this.parseModule(source);
        FBuilder root = this.element("module");
        if (module instanceof LibraryModule) {
            QNm name = module.sc.module;
            root.add(Q_PREFIX, name.string()).add(Q_URI, name.uri());
        }
        if ((doc = module.doc()) != null) {
            this.comment(doc, root);
        }
        for (StaticVar sv : module.vars) {
            root.add(this.variable(sv));
        }
        for (StaticFunc sf : module.funcs) {
            root.add(this.function(sf.name, sf, sf.funcType(), sf.anns));
        }
        return root.finish();
    }

    private FNode variable(StaticVar sv) throws QueryException {
        FBuilder variable = this.element("variable");
        byte[] name = sv.name.string();
        byte[] uri = sv.name.uri();
        variable.add(Q_NAME, name);
        if (uri.length != 0) {
            variable.add(Q_URI, uri);
        }
        PlainDoc.type(sv.seqType(), variable);
        variable.add(Q_EXTERNAL, sv.external);
        this.comment(sv, variable);
        this.annotation(sv.anns, variable, true);
        return variable.finish();
    }

    FNode function(QNm fname, StaticFunc sf, FuncType ft, AnnList anns) throws QueryException {
        TokenList returns;
        FBuilder function = this.element("function");
        if (fname != null) {
            function.add(Q_NAME, fname.string());
            if (fname.uri().length != 0) {
                function.add(Q_URI, fname.uri());
            }
        }
        function.add(Q_EXTERNAL, sf != null && sf.expr == null);
        TokenObjectMap<TokenList> doc = sf != null ? sf.doc() : null;
        int al = ft.argTypes.length;
        QNm[] names = null;
        if (sf != null) {
            names = new QNm[al];
            for (int n = 0; n < al; ++n) {
                names[n] = sf.params[n].name;
            }
        }
        for (int a = 0; a < al; ++a) {
            FBuilder argument = this.element("argument");
            if (names != null) {
                byte[] name = names[a].string();
                byte[] uri = names[a].uri();
                byte[] pdoc = PlainDoc.doc(doc, name);
                argument.add(Q_NAME, name);
                if (uri.length != 0) {
                    argument.add(Q_URI, uri);
                }
                if (pdoc != null) {
                    PlainDoc.add(pdoc, argument);
                }
            }
            PlainDoc.type(ft.argTypes[a], argument);
            function.add(argument);
        }
        this.annotation(anns, function, true);
        if (doc != null) {
            for (byte[] key : doc) {
                if (Token.eq(key, DOC_PARAM, DOC_RETURN)) continue;
                for (byte[] value : doc.get(key)) {
                    FBuilder elem = Token.eq(key, DOC_TAGS) ? this.element(Token.string(key)) : this.element("tag").add(Q_NAME, key);
                    PlainDoc.add(value, elem);
                    function.add(elem);
                }
            }
        }
        FBuilder rtrn = this.element("return");
        PlainDoc.type(ft.declType, rtrn);
        TokenList tokenList = returns = doc != null ? doc.get(DOC_RETURN) : null;
        if (returns != null) {
            for (byte[] value : returns) {
                PlainDoc.add(value, rtrn);
            }
        }
        return function.add(rtrn).finish();
    }

    @Override
    protected FBuilder element(String name) {
        return FElem.build(new QNm(name));
    }

    private void comment(StaticScope scope, FBuilder parent) throws QueryException {
        TokenObjectMap<TokenList> tags = scope.doc();
        if (tags != null) {
            this.comment(tags, parent);
        }
    }

    @Override
    protected FBuilder element(byte[] tag) {
        String string = Token.string(tag);
        return this.element((String)(Token.eq(tag, DOC_TAGS) ? string : string + "_tag"));
    }

    private static void type(SeqType st, FBuilder elem) {
        if (st != null) {
            elem.add(Q_TYPE, st.typeString());
            String occ = st.occ.toString();
            if (!occ.isEmpty()) {
                elem.add(Q_OCCURRENCE, occ);
            }
        }
    }
}

