/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import org.basex.gui.GUIConstants;
import org.basex.util.Prop;

public enum BaseXKeys {
    PREVCHAR(0, 37, 64),
    NEXTCHAR(0, 39, 64),
    PREVWORD(Prop.MAC ? 512 : GUIConstants.META, 37, 64),
    NEXTWORD(Prop.MAC ? 512 : GUIConstants.META, 39, 64),
    LINESTART(Prop.MAC ? GUIConstants.META : 0, Prop.MAC ? 37 : 36, 64),
    LINEEND(Prop.MAC ? GUIConstants.META : 0, Prop.MAC ? 39 : 35, 64),
    PREVLINE(0, 38, 64),
    NEXTLINE(0, 40, 64),
    PREVPAGE(0, 33, 64),
    NEXTPAGE(0, 34, 64),
    TEXTSTART(GUIConstants.META, Prop.MAC ? 38 : 36, 64),
    TEXTEND(GUIConstants.META, Prop.MAC ? 40 : 35, 64),
    SCROLLUP(Prop.MAC ? 512 : GUIConstants.META, 38),
    SCROLLDOWN(Prop.MAC ? 512 : GUIConstants.META, 40),
    TAB(0, 9, 64),
    PREVPAGE_RO(64, 32),
    NEXTPAGE_RO(0, 32),
    DELPREV(0, 8, 64),
    DELNEXT(0, 127),
    UNDOSTEP(GUIConstants.META, 90),
    REDOSTEP(Prop.MAC ? GUIConstants.META | 0x40 : GUIConstants.META, Prop.MAC ? 90 : 89),
    CUT1(GUIConstants.META, 88),
    CUT2(64, 127),
    COPY1(GUIConstants.META, 67),
    COPY2(GUIConstants.META, 155),
    PASTE1(GUIConstants.META, 86),
    PASTE2(64, 155),
    SELECTALL(GUIConstants.META, 65),
    MOVEDOWN(Prop.MAC ? 576 : 512, 40),
    MOVEUP(Prop.MAC ? 576 : 512, 38),
    COMPLETE(128, 32),
    DELPREVWORD(Prop.MAC ? 512 : GUIConstants.META, 8),
    DELNEXTWORD(Prop.MAC ? 512 : GUIConstants.META, 127),
    DELLINESTART(GUIConstants.META | (Prop.MAC ? 0 : 64), 8),
    DELLINEEND(GUIConstants.META | (Prop.MAC ? 0 : 64), 127),
    DELLINES(GUIConstants.META | 0x40, 68),
    DUPLLINES(GUIConstants.META, 68),
    FOCUSINPUT(Prop.MAC ? GUIConstants.META : 0, 119),
    FOCUSEDITOR(Prop.MAC ? GUIConstants.META : 0, 123),
    FOCUSTEXT(Prop.MAC ? GUIConstants.META | 0x40 : 64, 123),
    NEXTTAB(128, 9),
    PREVTAB(192, 9),
    CLOSETAB(GUIConstants.META, 115),
    GOBACK(Prop.MAC ? GUIConstants.META : 512, 37),
    GOFORWARD(Prop.MAC ? GUIConstants.META : 512, 39),
    GOUP(Prop.MAC ? GUIConstants.META : 512, 33),
    FILTER(Prop.MAC ? GUIConstants.META : 512, 34),
    GOHOME(Prop.MAC ? GUIConstants.META : 512, 36),
    GOTOLINE(GUIConstants.META, 76),
    FIND(GUIConstants.META, 70),
    FINDNEXT1(Prop.MAC ? GUIConstants.META : 0, 114),
    FINDNEXT2(GUIConstants.META, 71),
    FINDPREV1(Prop.MAC ? GUIConstants.META | 0x40 : 64, 114),
    FINDPREV2(GUIConstants.META | 0x40, 71),
    MATCHCASE(64, 115),
    WHOLEWORD(64, 116),
    REGEX(64, 117),
    MULTILINE(64, 118),
    INCFONT1(GUIConstants.META, 521),
    INCFONT2(GUIConstants.META, 61),
    DECFONT(GUIConstants.META, 45),
    NORMFONT(GUIConstants.META, 48),
    TESTS(GUIConstants.META | 0x40, 10),
    ESCAPE(0, 27),
    CONTEXT(0, 525),
    COPYPATH(GUIConstants.META | 0x40, 67),
    HISTORY(GUIConstants.META, 117),
    REFRESH(0, 116),
    RENAME(0, 113),
    NEWDIR(GUIConstants.META | 0x40, 78),
    SPACE(0, 32, 0x40 | GUIConstants.META),
    ENTER(0, 10),
    SHIFT_ENTER(64, 10);

    private final int modifiers;
    private final int key;
    private final int allowed;

    private BaseXKeys(int modifiers, int key, int allowed) {
        this.modifiers = modifiers;
        this.key = key;
        this.allowed = allowed;
    }

    private BaseXKeys(int m, int k) {
        this(m, k, 0);
    }

    public boolean is(KeyEvent e) {
        int c = e.getKeyCode();
        int m = e.getModifiersEx() | this.allowed;
        return m == (this.modifiers | this.allowed) && (c == 0 ? KeyEvent.getExtendedKeyCodeForChar(e.getKeyChar()) : c) == this.key;
    }

    public static boolean sc(InputEvent e) {
        return (GUIConstants.META & e.getModifiersEx()) == GUIConstants.META;
    }

    public static boolean control(KeyEvent e) {
        return e.isControlDown() || e.isMetaDown() || !Prop.MAC && e.isAltDown();
    }

    public static boolean modifier(KeyEvent e) {
        int c = e.getKeyCode();
        return c == 0 || c == 18 || c == 16 || c == 157 || c == 17 || c == 19 || c == 20 || c == 27 && !e.isShiftDown() || c == 9 && (e.isAltDown() || e.isMetaDown() || e.isControlDown());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(InputEvent.getModifiersExText(this.modifiers));
        if (!sb.isEmpty()) {
            sb.append('+');
        }
        return sb.append(KeyEvent.getKeyText(this.key)).toString();
    }

    String shortCut() {
        StringBuilder sb = new StringBuilder();
        if ((this.modifiers & 0x100) != 0) {
            sb.append("meta").append(' ');
        }
        if ((this.modifiers & 0x80) != 0) {
            sb.append("ctrl").append(' ');
        }
        if ((this.modifiers & 0x200) != 0) {
            sb.append("alt").append(' ');
        }
        if ((this.modifiers & 0x40) != 0) {
            sb.append("shift").append(' ');
        }
        if (this.key == 10) {
            sb.append("ENTER");
        } else if (this.key == 127) {
            sb.append("DELETE");
        } else if (this.key == 46) {
            sb.append("PERIOD");
        } else {
            sb.append(KeyEvent.getKeyText(this.key));
        }
        return sb.toString();
    }
}

