/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import java.io.IOException;
import org.basex.build.json.JsonOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.io.in.TextInput;
import org.basex.io.parse.json.JsonConverter;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenSet;

public final class JsonParser {
    private static final String[] CTRL = new String[]{"NUL", "SOH", "STX", "ETX", "EOT", "ENQ", "ACK", "BEL", "BS", "TAB", "LF", "VT", "FF", "CR", "SO", "SI", "DLE", "DC1", "DC2", "DC3", "DC4", "NAK", "SYN", "ETB", "CAN", "EM", "SUB", "ESC", "FS", "GS", "RS", "US"};
    private final JsonConverter conv;
    private final boolean liberal;
    private final boolean escape;
    private final JsonParserOptions.JsonDuplicates duplicates;
    private final TokenBuilder tb = new TokenBuilder();
    private final TextInput input;
    private InputInfo info;
    private int current;
    private long pos;
    private long line = 1L;
    private long col = 1L;
    private final int[] buf = new int[16];

    public JsonParser(TextInput input, JsonParserOptions opts, JsonConverter conv) {
        this.input = input;
        this.conv = conv;
        this.liberal = opts.get(JsonParserOptions.LIBERAL);
        this.escape = opts.get(JsonParserOptions.ESCAPE);
        JsonParserOptions.JsonDuplicates dupl = opts.get(JsonParserOptions.DUPLICATES);
        JsonOptions.JsonFormat jf = opts.get(JsonOptions.FORMAT);
        this.duplicates = dupl != null ? dupl : (jf == JsonOptions.JsonFormat.W3_XML || jf == JsonOptions.JsonFormat.BASIC ? JsonParserOptions.JsonDuplicates.RETAIN : JsonParserOptions.JsonDuplicates.USE_FIRST);
    }

    public void parse(InputInfo ii) throws QueryException, IOException {
        this.info = ii;
        try {
            this.current = this.input.read();
            this.consume(65279);
            this.skipWs();
            this.value();
        }
        catch (StackOverflowError er) {
            Util.debug(er);
            throw this.error("Input is too deeply nested", new Object[0]);
        }
        if (this.more()) {
            throw this.error("Unexpected trailing content: %", this.remaining());
        }
    }

    private void value() throws QueryException, IOException {
        if (!this.more()) {
            throw this.eof(", expected JSON value");
        }
        switch (this.current) {
            case 91: {
                this.array();
                break;
            }
            case 123: {
                this.object();
                break;
            }
            case 34: {
                this.conv.stringLit(this.string());
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.conv.numberLit(this.number());
                break;
            }
            case 116: {
                this.consume("true");
                this.conv.booleanLit(Token.TRUE);
                break;
            }
            case 102: {
                this.consume("false");
                this.conv.booleanLit(Token.FALSE);
                break;
            }
            case 110: {
                this.consume("null");
                this.conv.nullLit();
                break;
            }
            default: {
                throw this.error("Unexpected JSON value: '%'", this.remaining());
            }
        }
    }

    private void object() throws QueryException, IOException {
        this.consumeWs('{', true);
        this.conv.openObject();
        if (!this.consumeWs('}', false)) {
            TokenSet set = new TokenSet();
            do {
                byte[] key;
                boolean dupl;
                if ((dupl = set.contains(key = !this.liberal || this.current == 34 ? this.string() : this.unquoted())) && this.duplicates == JsonParserOptions.JsonDuplicates.REJECT) {
                    throw this.error(QueryError.DUPLICATE_JSON_X, "Key \"%\" occurs more than once", new Object[]{key});
                }
                boolean add = !dupl || this.duplicates != JsonParserOptions.JsonDuplicates.USE_FIRST;
                this.conv.openPair(key, add);
                this.consumeWs(':', true);
                this.value();
                this.conv.closePair(add);
                set.put(key);
            } while (this.consumeWs(',', false) && (!this.liberal || this.current != 125));
            this.consumeWs('}', true);
        }
        this.conv.closeObject();
    }

    private void array() throws QueryException, IOException {
        this.consumeWs('[', true);
        this.conv.openArray();
        if (!this.consumeWs(']', false)) {
            do {
                this.conv.openItem();
                this.value();
                this.conv.closeItem();
            } while (this.consumeWs(',', false) && (!this.liberal || this.current != 93));
            this.consumeWs(']', true);
        }
        this.conv.closeArray();
    }

    private byte[] unquoted() throws QueryException, IOException {
        if (!Character.isJavaIdentifierStart(this.current)) {
            throw this.error("Expected unquoted string, found %", this.remaining());
        }
        this.tb.reset();
        do {
            this.tb.add(this.consume());
        } while (Character.isJavaIdentifierPart(this.current));
        this.skipWs();
        return this.tb.toArray();
    }

    private byte[] number() throws QueryException, IOException {
        boolean zero;
        this.tb.reset();
        int cp = this.consume();
        this.tb.add(cp);
        if (cp == 45) {
            cp = this.consume();
            if (cp < 48 || cp > 57) {
                throw this.error("Number expected after '-'", new Object[0]);
            }
            this.tb.add(cp);
        }
        boolean bl = zero = cp == 48;
        if (zero && this.current >= 48 && this.current <= 57) {
            throw this.error("No digit allowed after '0'", new Object[0]);
        }
        block4: while (true) {
            switch (this.current) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.tb.add(this.consume());
                    continue block4;
                }
                case 46: 
                case 69: 
                case 101: {
                    break block4;
                }
                default: {
                    this.skipWs();
                    return this.tb.toArray();
                }
            }
            break;
        }
        if (this.consume(46)) {
            this.tb.add(46);
            if (this.current < 48 || this.current > 57) {
                throw this.error("Number expected after '.'", new Object[0]);
            }
            do {
                this.tb.add(this.consume());
            } while (this.current >= 48 && this.current <= 57);
            if (this.current != 101 && this.current != 69) {
                this.skipWs();
                return this.tb.toArray();
            }
        }
        this.tb.add(this.consume());
        if (this.current == 45 || this.current == 43) {
            this.tb.add(this.consume());
        }
        if (this.current < 48 || this.current > 57) {
            throw this.error("Exponent expected", new Object[0]);
        }
        do {
            this.tb.add(this.consume());
        } while (this.current >= 48 && this.current <= 57);
        this.skipWs();
        return this.tb.toArray();
    }

    private byte[] string() throws QueryException, IOException {
        if (!this.consume(34)) {
            throw this.error("Expected: string, found: %", this.currentAsString());
        }
        this.tb.reset();
        int high = 0;
        while (this.more()) {
            int cp;
            long p;
            block24: {
                block23: {
                    p = this.pos;
                    cp = this.consume();
                    if (cp == 34) {
                        if (high != 0) {
                            this.add(high, p - 6L, p);
                        }
                        this.skipWs();
                        return this.tb.toArray();
                    }
                    if (cp != 92) break block23;
                    cp = this.consume();
                    switch (cp) {
                        case 34: 
                        case 47: 
                        case 92: {
                            break block24;
                        }
                        case 98: {
                            cp = 8;
                            break block24;
                        }
                        case 102: {
                            cp = 12;
                            break block24;
                        }
                        case 110: {
                            cp = 10;
                            break block24;
                        }
                        case 114: {
                            cp = 13;
                            break block24;
                        }
                        case 116: {
                            cp = 9;
                            break block24;
                        }
                        case 117: {
                            cp = 0;
                            for (int i = 0; i < 4; ++i) {
                                if (!this.more()) {
                                    throw this.eof(", expected four-digit hex value");
                                }
                                int cp2 = this.consume();
                                if (cp2 >= 48 && cp2 <= 57) {
                                    cp = 16 * cp + cp2 - 48;
                                    continue;
                                }
                                if (cp2 >= 97 && cp2 <= 102) {
                                    cp = 16 * cp + cp2 + 10 - 97;
                                    continue;
                                }
                                if (cp2 >= 65 && cp2 <= 70) {
                                    cp = 16 * cp + cp2 + 10 - 65;
                                    continue;
                                }
                                throw this.error("Illegal hexadecimal digit: %", this.currentAsString());
                            }
                            break block24;
                        }
                        default: {
                            throw this.error("Unknown character escape: %", this.currentAsString());
                        }
                    }
                }
                if (!this.liberal && cp <= 31) {
                    throw this.error("Non-escaped control character: %", CTRL[cp]);
                }
            }
            if (high != 0) {
                if (cp >= 56320 && cp <= 57343) {
                    cp = (high - 55296 << 10) + cp - 56320 + 65536;
                } else {
                    this.add(high, p - 6L, p);
                }
                high = 0;
            }
            if (cp >= 55296 && cp <= 56319) {
                high = cp;
                continue;
            }
            this.add(cp, p, this.pos);
        }
        throw this.eof(" in string literal");
    }

    private void add(int cp, long s, long e) throws QueryException {
        if (this.escape) {
            if (cp == 92) {
                this.tb.add("\\\\");
            } else if (cp == 8) {
                this.tb.add("\\b");
            } else if (cp == 12) {
                this.tb.add("\\f");
            } else if (cp == 10) {
                this.tb.add("\\n");
            } else if (cp == 13) {
                this.tb.add("\\r");
            } else if (cp == 9) {
                this.tb.add("\\t");
            } else if (XMLToken.valid(cp)) {
                this.tb.add(cp);
            } else {
                this.tb.add("\\u").add(Token.hex(cp, 4));
            }
        } else if (XMLToken.valid(cp)) {
            this.tb.add(cp);
        } else if (this.conv.fallback == null) {
            this.tb.add(65533);
        } else {
            this.tb.add(this.conv.fallback.apply(this.substring(s, e).finish()));
        }
    }

    private void skipWs() throws IOException {
        block3: while (this.more()) {
            switch (this.current) {
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 160: {
                    this.consume();
                    continue block3;
                }
            }
            return;
        }
    }

    private boolean consumeWs(char ch, boolean err) throws QueryException, IOException {
        if (this.consume(ch)) {
            this.skipWs();
            return true;
        }
        if (err) {
            throw this.error("Expected: '%', found: %", Character.valueOf(ch), this.currentAsString());
        }
        return false;
    }

    private QueryException eof(String desc) throws QueryException {
        throw this.error("Unexpected end of input%", desc);
    }

    private QueryException error(String msg, Object ... ext) {
        return this.error(QueryError.PARSE_JSON_X_X_X, msg, ext);
    }

    private QueryException error(QueryError err, String msg, Object ... ext) {
        return err.get(this.info, this.line, this.col, Util.inf(msg, ext));
    }

    private boolean more() {
        return this.current >= 0;
    }

    private int consume() throws IOException {
        int cp = this.current;
        this.buf[(int)(this.pos++ % (long)this.buf.length)] = cp;
        if (cp == 10) {
            ++this.line;
            this.col = 1L;
        } else if (this.more()) {
            ++this.col;
        }
        this.current = this.input.read();
        return cp;
    }

    private boolean consume(int cp) throws IOException {
        if (cp != this.current) {
            return false;
        }
        this.consume();
        return true;
    }

    private void consume(String string) throws QueryException, IOException {
        long p = this.pos;
        long l = this.line;
        long c = this.col;
        long len = string.length();
        int i = 0;
        while ((long)i < len) {
            if (!this.consume(string.charAt(i))) {
                String s = String.valueOf(this.substring(p, this.pos)) + this.remaining();
                this.line = l;
                this.col = c;
                throw this.error("Unexpected JSON value: '%'", s);
            }
            ++i;
        }
        this.skipWs();
    }

    private TokenBuilder substring(long s, long e) {
        TokenBuilder t = new TokenBuilder();
        for (long i = s; i < e; ++i) {
            t.add(this.buf[(int)(i % (long)this.buf.length)]);
        }
        return t;
    }

    private String remaining() throws IOException {
        int cp;
        this.tb.reset();
        for (int i = 0; i < 15 && this.more() && (cp = this.consume()) != 10; ++i) {
            this.tb.add(cp);
        }
        return String.valueOf(this.tb) + (this.more() ? "..." : "");
    }

    private String currentAsString() {
        return !this.more() ? "END OF INPUT" : (!XMLToken.valid(this.current) || Character.isSpaceChar(this.current) ? Character.getName(this.current) : Character.toString(this.current));
    }
}

