/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Union;
import org.basex.query.expr.path.Path;
import org.basex.query.expr.path.PathCache;
import org.basex.query.expr.path.Step;
import org.basex.query.iter.Iter;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.util.InputInfo;

public abstract class AxisPath
extends Path {
    AxisPath(InputInfo info, Expr root, Expr ... steps) {
        super(info, NodeType.NODE, root, steps);
    }

    @Override
    public final Iter iter(QueryContext qc) throws QueryException {
        Value cached = this.cache(qc);
        return cached != null ? cached.iter() : this.iterator(qc);
    }

    @Override
    public final Value value(QueryContext qc) throws QueryException {
        Value cached = this.cache(qc);
        return cached != null ? cached : this.nodes(qc);
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        Value cached = this.cache(qc);
        return cached != null ? cached != Empty.VALUE : this.iterator(qc).next() != null;
    }

    private Value cache(QueryContext qc) throws QueryException {
        Value value = qc.focus.value;
        if (this.root == null && value == Empty.VALUE) {
            return value;
        }
        PathCache cache = qc.threads.get(this).get();
        switch (cache.state) {
            case INIT: {
                cache.init(value, this);
                break;
            }
            case ENABLED: {
                if (cache.valid(value)) {
                    cache.cache(this.nodes(qc));
                    break;
                }
                cache.disable();
                break;
            }
            case CACHED: {
                if (cache.valid(value)) break;
                cache.update(value, this.nodes(qc));
                break;
            }
        }
        return cache.result;
    }

    protected abstract Iter iterator(QueryContext var1) throws QueryException;

    protected abstract Value nodes(QueryContext var1) throws QueryException;

    public final Step step(int index) {
        return (Step)this.steps[index];
    }

    public final Expr addPredicates(CompileContext cc, Expr ... preds) throws QueryException {
        ExprList list = new ExprList(this.steps);
        Step step = ((Step)list.pop()).addPredicates(preds);
        list.add(cc.get(step, true, () -> step.optimize(this.root, cc)));
        this.exprType.assign(this.seqType().union(Occ.ZERO));
        return this.copyType(AxisPath.get(cc, this.info, this.root, (Expr[])list.finish()));
    }

    @Override
    public final Expr mergeEbv(Expr expr, boolean or, CompileContext cc) throws QueryException {
        return or && expr instanceof AxisPath ? new Union(this.info, this, expr).optimize(cc) : null;
    }

    @Override
    public final boolean ddo() {
        return true;
    }
}

