/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.fingertree;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.basex.query.util.fingertree.DeepTree;
import org.basex.query.util.fingertree.FingerTree;
import org.basex.query.util.fingertree.FingerTreeIterator;
import org.basex.query.util.fingertree.InnerNode;
import org.basex.query.util.fingertree.Node;
import org.basex.query.util.fingertree.SingletonTree;
import org.basex.util.Array;
import org.basex.util.Util;

public final class FingerTreeBuilder<E>
implements Iterable<E> {
    private BufferNode<E, E> root;

    public boolean isEmpty() {
        return this.root == null;
    }

    public void prepend(Node<E, E> leaf) {
        if (this.root == null) {
            this.root = new BufferNode<E, E>(leaf);
        } else {
            this.root.prepend(leaf);
        }
    }

    public void append(Node<E, E> leaf) {
        if (this.root == null) {
            this.root = new BufferNode<E, E>(leaf);
        } else {
            this.root.append(leaf);
        }
    }

    public void append(FingerTree<E, E> tree) {
        if (!tree.isEmpty()) {
            if (this.root == null) {
                this.root = new BufferNode<E, E>(tree);
            } else {
                this.root.append(tree);
            }
        }
    }

    public FingerTree<E, E> freeze() {
        return this.root == null ? FingerTree.empty() : this.root.freeze();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(Util.className(this)).append('[');
        Iterator<E> iter = this.iterator();
        if (iter.hasNext()) {
            sb.append(iter.next());
            while (iter.hasNext()) {
                sb.append(", ").append(iter.next());
            }
        }
        return sb.append(']').toString();
    }

    @Override
    public Iterator<E> iterator() {
        if (this.root == null) {
            return Collections.emptyIterator();
        }
        return new BufferNodeIterator<E>(this.root);
    }

    private static final class BufferNode<N, E> {
        private static final int NODE_SIZE = 4;
        private static final int MAX_DIGIT = 5;
        private static final int CAP = 10;
        final Node<N, E>[] nodes = new Node[10];
        int inLeft;
        int midPos = 5;
        int inRight;
        Object middle;

        BufferNode(Node<N, E> node) {
            this.prepend(node);
        }

        BufferNode(FingerTree<N, E> tree) {
            if (tree instanceof SingletonTree) {
                this.prepend(((SingletonTree)tree).elem);
            } else {
                DeepTree deep = (DeepTree)tree;
                int i = deep.left.length;
                while (--i >= 0) {
                    this.prepend(deep.left[i]);
                }
                FingerTree mid = deep.middle;
                if (!mid.isEmpty()) {
                    this.middle = mid;
                }
                for (Node node : deep.right) {
                    this.append(node);
                }
            }
        }

        void prepend(Node<N, E> node) {
            if (this.inLeft < 5) {
                this.nodes[(this.midPos - this.inLeft - 1 + 10) % 10] = node;
                ++this.inLeft;
            } else if (this.middle == null && this.inRight < 5) {
                this.midPos = (this.midPos - 1 + 10) % 10;
                this.nodes[(this.midPos - this.inLeft + 10) % 10] = node;
                ++this.inRight;
            } else {
                int l = (this.midPos - this.inLeft + 10) % 10;
                InnerNode<N, E> next = new InnerNode<N, E>(this.copy(l + 1, this.inLeft - 1));
                this.nodes[(this.midPos - 1 + 10) % 10] = this.nodes[l];
                this.nodes[(this.midPos - 2 + 10) % 10] = node;
                this.inLeft = 2;
                if (this.middle == null) {
                    this.middle = new BufferNode<N, E>(next);
                } else {
                    this.midBuffer().prepend(next);
                }
            }
        }

        void append(Node<N, E> node) {
            if (this.inRight < 5) {
                this.nodes[(this.midPos + this.inRight) % 10] = node;
                ++this.inRight;
            } else if (this.middle == null && this.inLeft < 5) {
                this.midPos = (this.midPos + 1) % 10;
                this.nodes[(this.midPos + this.inRight - 1) % 10] = node;
                ++this.inLeft;
            } else {
                InnerNode<N, E> next = new InnerNode<N, E>(this.copy(this.midPos, this.inRight - 1));
                this.nodes[this.midPos] = this.nodes[(this.midPos + this.inRight - 1) % 10];
                this.nodes[(this.midPos + 1) % 10] = node;
                this.inRight = 2;
                if (this.middle == null) {
                    this.middle = new BufferNode<N, E>(next);
                } else {
                    this.midBuffer().append(next);
                }
            }
        }

        void append(FingerTree<N, E> tree) {
            if (!(tree instanceof DeepTree)) {
                if (tree instanceof SingletonTree) {
                    this.append(((SingletonTree)tree).elem);
                }
                return;
            }
            DeepTree deep = (DeepTree)tree;
            Node<N, E>[] ls = deep.left;
            Node<N, E>[] rs = deep.right;
            int ll = ls.length;
            FingerTree mid = deep.middle;
            if (mid.isEmpty()) {
                for (Node l : ls) {
                    this.append(l);
                }
                for (Node r : rs) {
                    this.append(r);
                }
            } else if (this.middle == null) {
                int n = this.inLeft + this.inRight;
                Node[] buff = new Node[n + ll];
                this.copyInto(this.midPos - this.inLeft, buff, 0, n);
                Array.copyFromStart(ls, ll, buff, n);
                this.inRight = 0;
                this.inLeft = 0;
                this.middle = mid;
                int i = buff.length;
                while (--i >= 0) {
                    this.prepend(buff[i]);
                }
                for (Node r : rs) {
                    this.append(r);
                }
            } else {
                int n = this.inRight + ll;
                Node[] buff = new Node[n];
                this.copyInto(this.midPos, buff, 0, this.inRight);
                Array.copyFromStart(ls, ll, buff, this.inRight);
                this.inRight = 0;
                int p = 0;
                for (int k = (n + 4 - 1) / 4; k > 0; --k) {
                    int inNode = (n - p + k - 1) / k;
                    Node[] out = new Node[inNode];
                    Array.copyToStart(buff, p, inNode, out);
                    InnerNode sub = new InnerNode(out);
                    if (this.middle == null) {
                        this.middle = new BufferNode(sub);
                    } else {
                        this.midBuffer().append(sub);
                    }
                    p += inNode;
                }
                if (this.middle == null) {
                    this.middle = mid;
                } else {
                    this.midBuffer().append(mid);
                }
                for (Node r : rs) {
                    this.append(r);
                }
            }
        }

        FingerTree<N, E> freeze() {
            int n = this.inLeft + this.inRight;
            if (n == 1) {
                return new SingletonTree<N, E>(this.nodes[(this.midPos + this.inRight - 1 + 10) % 10]);
            }
            int a = this.middle == null ? n / 2 : this.inLeft;
            int l = this.midPos - this.inLeft;
            Node<N, E>[] left = this.copy(l, a);
            Node<N, E>[] right = this.copy(l + a, n - a);
            if (this.middle == null) {
                return DeepTree.get(left, right);
            }
            if (this.middle instanceof FingerTree) {
                FingerTree tree = (FingerTree)this.middle;
                return DeepTree.get(left, tree, right);
            }
            BufferNode buffer = (BufferNode)this.middle;
            return DeepTree.get(left, buffer.freeze(), right);
        }

        Node<N, E> get(int pos) {
            return this.nodes[((this.midPos + pos) % 10 + 10) % 10];
        }

        private BufferNode<Node<N, E>, E> midBuffer() {
            BufferNode<N, E> mid;
            if (this.middle == null) {
                return null;
            }
            if (this.middle instanceof BufferNode) {
                return (BufferNode)this.middle;
            }
            this.middle = mid = new BufferNode<N, E>((FingerTree)this.middle);
            return mid;
        }

        private Node<N, E>[] copy(int start, int len) {
            Node[] out = new Node[len];
            this.copyInto(start, out, 0, len);
            return out;
        }

        private void copyInto(int start, Node<N, E>[] arr, int pos, int len) {
            int p = (start % 10 + 10) % 10;
            int k = 10 - p;
            if (len <= k) {
                Array.copy(this.nodes, p, len, arr, pos);
            } else {
                Array.copy(this.nodes, p, k, arr, pos);
                Array.copyFromStart(this.nodes, len - k, arr, pos + k);
            }
        }
    }

    private static final class BufferNodeIterator<E>
    implements Iterator<E> {
        private BufferNode<?, E>[] stack = new BufferNode[8];
        private int[] poss = new int[8];
        private int top;
        private Iterator<E> sub;

        BufferNodeIterator(BufferNode<E, E> root) {
            int pos;
            this.stack[0] = root;
            this.poss[0] = pos = -root.inLeft;
            this.sub = new FingerTreeIterator<E>(root.get(pos), 0L);
        }

        @Override
        public boolean hasNext() {
            return this.sub != null;
        }

        @Override
        public E next() {
            E out = this.sub.next();
            if (this.sub.hasNext()) {
                return out;
            }
            this.sub = null;
            BufferNode<?, E> buffer = this.stack[this.top];
            int n = this.top;
            this.poss[n] = this.poss[n] + 1;
            if (this.poss[this.top] < 0) {
                this.sub = new FingerTreeIterator<E>(buffer.get(this.poss[this.top]), 0L);
                return out;
            }
            if (this.poss[this.top] == 0) {
                Object mid = buffer.middle;
                if (mid != null) {
                    if (mid instanceof FingerTree) {
                        this.sub = ((FingerTree)mid).iterator();
                    } else {
                        BufferNode buff = (BufferNode)mid;
                        if (++this.top == this.stack.length) {
                            this.stack = Arrays.copyOf(this.stack, 2 * this.top);
                            this.poss = Arrays.copyOf(this.poss, 2 * this.top);
                        }
                        this.stack[this.top] = buff;
                        this.poss[this.top] = -buff.inLeft;
                        this.sub = new FingerTreeIterator(buff.get(this.poss[this.top]), 0L);
                    }
                    return out;
                }
                int n2 = this.top;
                this.poss[n2] = this.poss[n2] + 1;
            }
            if (this.poss[this.top] <= buffer.inRight) {
                this.sub = new FingerTreeIterator<E>(buffer.get(this.poss[this.top] - 1), 0L);
                return out;
            }
            this.stack[this.top] = null;
            if (--this.top >= 0) {
                this.sub = new FingerTreeIterator<E>(this.stack[this.top].get(0), 0L);
                int n3 = this.top;
                this.poss[n3] = this.poss[n3] + 1;
            }
            return out;
        }

        @Override
        public void remove() {
            throw Util.notExpected();
        }
    }
}

