/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import org.basex.core.jobs.Job;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.ArrBuilder;
import org.basex.query.value.array.ItemArray;
import org.basex.query.value.array.TreeArrayBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.Types;

public final class ArrayBuilder {
    private final Job job;
    private ArrBuilder builder;
    private final long capacity;
    private Value single;

    public ArrayBuilder(Job job) {
        this(job, -1L);
    }

    public ArrayBuilder(Job job, long capacity) {
        this.job = job;
        this.capacity = capacity;
    }

    public ArrayBuilder add(Value value) {
        if (this.builder == null) {
            this.job.checkStop();
            Value sngl = this.single;
            if (sngl == null) {
                this.single = value;
                return this;
            }
            this.single = null;
            this.builder = this.capacity == Long.MIN_VALUE || sngl.size() != 1L || value.size() != 1L ? new TreeArrayBuilder() : new ItemArrayBuilder();
            this.add(sngl);
        }
        this.builder = this.builder.add(value);
        return this;
    }

    public XQArray array() {
        return this.array(Types.ARRAY);
    }

    public XQArray array(ArrayType type) {
        try {
            XQArray xQArray = this.builder != null ? this.builder.array(type) : (this.single != null ? XQArray.get(this.single) : XQArray.empty());
            return xQArray;
        }
        finally {
            this.builder = null;
            this.single = null;
        }
    }

    public XQArray array(Expr expr) {
        return expr != null ? this.array((ArrayType)expr.seqType().type) : this.array();
    }

    final class ItemArrayBuilder
    extends ArrBuilder {
        private final ValueBuilder vb;

        ItemArrayBuilder() {
            this.vb = new ValueBuilder(ArrayBuilder.this.job, ArrayBuilder.this.capacity);
        }

        @Override
        public ArrBuilder add(Value value) {
            if (value.size() == 1L) {
                this.vb.add(value);
                return this;
            }
            TreeArrayBuilder ab = new TreeArrayBuilder();
            for (Value member : this.vb.value()) {
                ab.add(member);
            }
            return ab.add(value);
        }

        @Override
        public XQArray array(ArrayType type) {
            return new ItemArray(this.vb.value(type.valueType().type));
        }
    }
}

