##############################################################################
# Copyright (c) 2016-24, Lawrence Livermore National Security, LLC and Umpire
# project contributors. See the COPYRIGHT file for details.
#
# SPDX-License-Identifier: (MIT)
##############################################################################

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was umpire-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################
  
include(CMakeFindDependencyMacro)

# cache the prefix dir (could be overriden by find_dependency)
set(UMPIRE_PACKAGE_PREFIX_DIR ${PACKAGE_PREFIX_DIR})

if ()
  set(BLT_TGTS "${CMAKE_CURRENT_LIST_DIR}/bltTargets.cmake")
  if(EXISTS "${BLT_TGTS}")
    include("${BLT_TGTS}")
  endif()
  unset(BLT_TGTS)
endif()

if (Off OR ON OR Off)
  find_dependency(Threads)
endif ()

if (NOT TARGET camp)
  set(UMPIRE_CAMP_DIR "/opt/local")
  if(NOT camp_DIR) 
    set(camp_DIR ${UMPIRE_CAMP_DIR}) 
  endif()

  find_dependency(camp CONFIG NO_DEFAULT_PATH PATHS 
    ${camp_DIR}
    ${camp_DIR}/lib/cmake/camp
    ${UMPIRE_PACKAGE_PREFIX_DIR}
    ${UMPIRE_PACKAGE_PREFIX_DIR}/lib/cmake/camp)
endif ()

if (Off)
  find_dependency(Threads)
endif ()

if (NOT TARGET fmt::fmt-header-only)
  set(UMPIRE_FMT_DIR "/opt/local/lib/libfmt11/cmake/fmt")
  if(NOT fmt_DIR)
    set(fmt_DIR ${UMPIRE_FMT_DIR})
  endif()

  find_dependency(fmt CONFIG NO_DEFAULT_PATH PATHS
    ${fmt_DIR}
    ${fmt_DIR}/lib64/cmake/fmt
    ${UMPIRE_PACKAGE_PREFIX_DIR}
    ${UMPIRE_PACKAGE_PREFIX_DIR}/lib64/cmake/fmt)
endif ()

if (OFF)
  find_package(SQLite3 REQUIRED)
endif()

include("${CMAKE_CURRENT_LIST_DIR}/BLTSetupTargets.cmake")
include("${CMAKE_CURRENT_LIST_DIR}/umpire-targets.cmake")

check_required_components(Umpire)
