/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.PrimaryKeyAssigner;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredMap;
import com.sleepycat.db.Database;
import com.sleepycat.db.OperationStatus;
import java.util.Comparator;
import java.util.SortedMap;

public class StoredSortedMap<K, V>
extends StoredMap<K, V>
implements SortedMap<K, V> {
    public StoredSortedMap(Database database, EntryBinding<K> entryBinding, EntryBinding<V> entryBinding2, boolean bl) {
        super(new DataView(database, entryBinding, entryBinding2, null, bl, null));
    }

    public StoredSortedMap(Database database, EntryBinding<K> entryBinding, EntryBinding<V> entryBinding2, PrimaryKeyAssigner primaryKeyAssigner) {
        super(new DataView(database, entryBinding, entryBinding2, null, true, primaryKeyAssigner));
    }

    public StoredSortedMap(Database database, EntryBinding<K> entryBinding, EntityBinding<V> entityBinding, boolean bl) {
        super(new DataView(database, entryBinding, null, entityBinding, bl, null));
    }

    public StoredSortedMap(Database database, EntryBinding<K> entryBinding, EntityBinding<V> entityBinding, PrimaryKeyAssigner primaryKeyAssigner) {
        super(new DataView(database, entryBinding, null, entityBinding, true, primaryKeyAssigner));
    }

    StoredSortedMap(DataView dataView) {
        super(dataView);
    }

    @Override
    public Comparator<? super K> comparator() {
        return null;
    }

    @Override
    public K firstKey() {
        return this.getFirstOrLastKey(true);
    }

    @Override
    public K lastKey() {
        return this.getFirstOrLastKey(false);
    }

    private K getFirstOrLastKey(boolean bl) {
        Object object;
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.view, false);
            OperationStatus operationStatus = bl ? dataCursor.getFirst(false) : dataCursor.getLast(false);
            object = operationStatus == OperationStatus.SUCCESS ? dataCursor.getCurrentKey() : null;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
        this.closeCursor(dataCursor);
        return (K)object;
    }

    @Override
    public SortedMap<K, V> headMap(K k) {
        return this.subMap(null, false, k, false);
    }

    public SortedMap<K, V> headMap(K k, boolean bl) {
        return this.subMap(null, false, k, bl);
    }

    @Override
    public SortedMap<K, V> tailMap(K k) {
        return this.subMap(k, true, null, false);
    }

    public SortedMap<K, V> tailMap(K k, boolean bl) {
        return this.subMap(k, bl, null, false);
    }

    @Override
    public SortedMap<K, V> subMap(K k, K k2) {
        return this.subMap(k, true, k2, false);
    }

    public SortedMap<K, V> subMap(K k, boolean bl, K k2, boolean bl2) {
        try {
            return new StoredSortedMap<K, V>(this.view.subView(k, bl, k2, bl2, null));
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }
}

