/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.ComparatorCatalog;
import com.sleepycat.persist.impl.CompositeKeyFormat;
import com.sleepycat.persist.impl.EnumFormat;
import com.sleepycat.persist.impl.FieldInfo;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistKeyBinding;
import com.sleepycat.persist.impl.SimpleCatalog;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PersistComparator
implements Comparator<byte[]>,
Serializable {
    private static final long serialVersionUID = 5221576538843355317L;
    private String keyClassName;
    private String[] comositeFieldOrder;
    private Map<String, String[]> fieldFormatData;
    private transient PersistKeyBinding binding;

    public PersistComparator(PersistKeyBinding persistKeyBinding) {
        this.binding = persistKeyBinding;
        CompositeKeyFormat compositeKeyFormat = (CompositeKeyFormat)persistKeyBinding.keyFormat;
        this.keyClassName = compositeKeyFormat.getClassName();
        this.comositeFieldOrder = CompositeKeyFormat.getFieldNameArray(compositeKeyFormat.getClassMetadata().getCompositeKeyFields());
        for (FieldInfo fieldInfo : compositeKeyFormat.getFieldInfo()) {
            Format format = fieldInfo.getType();
            if (!format.isEnum()) continue;
            EnumFormat enumFormat = (EnumFormat)format;
            if (this.fieldFormatData == null) {
                this.fieldFormatData = new HashMap<String, String[]>();
            }
            this.fieldFormatData.put(enumFormat.getClassName(), enumFormat.getFormatData());
        }
    }

    @Override
    public int compare(byte[] byArray, byte[] byArray2) {
        Object object;
        Object object2;
        if (this.binding == null) {
            Iterator iterator;
            object2 = SimpleCatalog.getInstance();
            object = null;
            if (this.fieldFormatData != null) {
                object = new HashMap();
                for (Map.Entry object3 : this.fieldFormatData.entrySet()) {
                    Class clazz;
                    String string = (String)object3.getKey();
                    String[] stringArray = (String[])object3.getValue();
                    try {
                        clazz = SimpleCatalog.classForName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new IllegalStateException(classNotFoundException);
                    }
                    object.put(string, new EnumFormat(clazz, stringArray));
                }
                object2 = new ComparatorCatalog((Map<String, Format>)object);
                for (Format format : object.values()) {
                    format.initializeIfNeeded((Catalog)object2, null);
                }
            }
            try {
                iterator = SimpleCatalog.classForName(this.keyClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException(classNotFoundException);
            }
            this.binding = new PersistKeyBinding((Catalog)object2, (Class)((Object)iterator), this.comositeFieldOrder);
        }
        object2 = (Comparable)this.binding.bytesToObject(byArray, 0, byArray.length);
        object = (Comparable)this.binding.bytesToObject(byArray2, 0, byArray2.length);
        return object2.compareTo(object);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[DPL comparator ");
        stringBuilder.append(" keyClassName = ").append(this.keyClassName);
        stringBuilder.append(" comositeFieldOrder = [");
        for (String string : this.comositeFieldOrder) {
            stringBuilder.append(string).append(',');
        }
        stringBuilder.append(']');
        stringBuilder.append(" fieldFormatData = {");
        for (Map.Entry entry : this.fieldFormatData.entrySet()) {
            stringBuilder.append((String)entry.getKey()).append(": [");
            for (String string : (String[])entry.getValue()) {
                stringBuilder.append(string).append(',');
            }
            stringBuilder.append(']');
        }
        stringBuilder.append('}');
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

