/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ResourceManager;

abstract class AbstractResourceManager
extends ResourceManager {
    private Map<DeviceResourceDescriptor<?>, RefCount<?>> map = null;

    AbstractResourceManager() {
    }

    private <R> RefCount<R> getRefCount(DeviceResourceDescriptor<R> descriptor) {
        return this.map.get(descriptor);
    }

    protected abstract <R> R allocate(DeviceResourceDescriptor<R> var1) throws DeviceResourceException;

    protected abstract <R> void deallocate(Object var1, DeviceResourceDescriptor<R> var2);

    @Override
    public final <R> R create(DeviceResourceDescriptor<R> descriptor) throws DeviceResourceException {
        RefCount<R> count;
        if (this.map == null) {
            this.map = new HashMap();
        }
        if ((count = this.getRefCount(descriptor)) != null) {
            ++count.count;
            return count.resource;
        }
        R resource = this.allocate(descriptor);
        count = new RefCount<R>(resource);
        this.map.put(descriptor, count);
        return resource;
    }

    @Override
    public final <R> void destroy(DeviceResourceDescriptor<R> descriptor) {
        if (this.map == null) {
            return;
        }
        RefCount<R> count = this.getRefCount(descriptor);
        if (count != null) {
            --count.count;
            if (count.count == 0) {
                this.deallocate(count.resource, descriptor);
                this.map.remove(descriptor);
            }
        }
        if (this.map.isEmpty()) {
            this.map = null;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.map == null) {
            return;
        }
        this.map.forEach((key, val) -> this.deallocate(val.resource, (DeviceResourceDescriptor)key));
        this.map = null;
    }

    @Override
    public <R> R find(DeviceResourceDescriptor<R> descriptor) {
        if (this.map == null) {
            return null;
        }
        RefCount<R> refCount = this.getRefCount(descriptor);
        if (refCount == null) {
            return null;
        }
        return refCount.resource;
    }

    private static class RefCount<R> {
        final R resource;
        int count = 1;

        RefCount(R resource) {
            this.resource = resource;
        }
    }
}

