/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class ActionBars {
    @Nullable
    public static IStatusLineManager extractStatusLineManager(@NotNull IWorkbenchSite site) {
        IActionBars actionBars = ActionBars.extractActionBars(site);
        if (actionBars == null) {
            return null;
        }
        return actionBars.getStatusLineManager();
    }

    @Nullable
    public static IActionBars extractActionBars(@NotNull IWorkbenchSite site) {
        IEditorPart activeEditorPart;
        IEditorActionBarContributor contributor;
        IWorkbenchPage page = site.getPage();
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof IViewPart) {
            IViewPart activeViewPart = (IViewPart)activePart;
            IViewSite activeViewSite = activeViewPart.getViewSite();
            return activeViewSite.getActionBars();
        }
        if (activePart instanceof IEditorPart && (contributor = (activeEditorPart = (IEditorPart)activePart).getEditorSite().getActionBarContributor()) instanceof EditorActionBarContributor) {
            EditorActionBarContributor abc = (EditorActionBarContributor)contributor;
            return abc.getActionBars();
        }
        if (site instanceof IViewSite) {
            IViewSite viewSite = (IViewSite)site;
            return viewSite.getActionBars();
        }
        if (site instanceof IEditorSite) {
            IEditorSite editorSite = (IEditorSite)site;
            return editorSite.getActionBars();
        }
        return null;
    }
}

