/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IViewerCreator;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.IViewerDescriptor;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public class ViewerDescriptor
implements IViewerDescriptor {
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String EXTENSIONS_ATTRIBUTE = "extensions";
    private static final String LINKED_EDITOR_ATTRIBUTE = "linkedEditor";
    private static final String LABEL_ATTRIBUTE = "label";
    private final IConfigurationElement fConfiguration;
    private IViewerCreator fViewerCreator;
    private Class<? extends Viewer> fViewerClass;

    public ViewerDescriptor(IConfigurationElement config) {
        this.fConfiguration = config;
    }

    @Override
    public Viewer createViewer(Viewer currentViewer, Composite parent, CompareConfiguration mp) {
        if (currentViewer != null && currentViewer.getClass() == this.fViewerClass) {
            return currentViewer;
        }
        if (this.fViewerCreator == null) {
            try {
                this.fViewerCreator = (IViewerCreator)this.fConfiguration.createExecutableExtension(CLASS_ATTRIBUTE);
            }
            catch (CoreException e) {
                CompareUIPlugin.log(e);
            }
        }
        if (this.fViewerCreator != null) {
            Viewer viewer;
            CompareHandlerService[] compareHandlerService;
            if (currentViewer != null && (compareHandlerService = (CompareHandlerService[])Adapters.adapt((Object)currentViewer, CompareHandlerService[].class)) != null) {
                CompareHandlerService[] compareHandlerServiceArray = compareHandlerService;
                int n = compareHandlerService.length;
                int n2 = 0;
                while (n2 < n) {
                    CompareHandlerService s = compareHandlerServiceArray[n2];
                    s.dispose();
                    ++n2;
                }
            }
            if ((viewer = this.fViewerCreator.createViewer(parent, mp)) != null) {
                this.fViewerClass = viewer.getClass();
            }
            return viewer;
        }
        return null;
    }

    public String getExtension() {
        return this.fConfiguration.getAttribute(EXTENSIONS_ATTRIBUTE);
    }

    String getLabel() {
        return this.fConfiguration.getAttribute(LABEL_ATTRIBUTE);
    }

    String getLinkedEditorId() {
        return this.fConfiguration.getAttribute(LINKED_EDITOR_ATTRIBUTE);
    }

    String getViewerClass() {
        return this.fConfiguration.getAttribute(CLASS_ATTRIBUTE);
    }

    public String toString() {
        String viewerClass;
        StringBuilder sb = new StringBuilder();
        sb.append("ViewerDescriptor [");
        if (this.fViewerClass != null) {
            sb.append("viewerClass=");
            sb.append(this.fViewerClass);
            sb.append(", ");
        }
        if (this.fViewerCreator != null) {
            sb.append("viewerCreator=");
            sb.append(this.fViewerCreator);
            sb.append(", ");
        }
        if ((viewerClass = this.getViewerClass()) != null) {
            sb.append("viewerClass=");
            sb.append(viewerClass);
            sb.append(", ");
        }
        if (this.fConfiguration != null) {
            sb.append("configuration=");
            sb.append(this.fConfiguration);
        }
        sb.append("]");
        return sb.toString();
    }
}

