/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchedulerJob;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSParameter;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class OracleSchedulerJobArgument
implements DBSParameter {
    private final OracleSchedulerJob job;
    private String name;
    private int position;
    private final String type;
    private String value;
    private String anyDataValue;
    private String outArgument;

    public OracleSchedulerJobArgument(OracleSchedulerJob job, ResultSet dbResult) {
        this.job = job;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ARGUMENT_NAME");
        this.position = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"ARGUMENT_POSITION");
        this.type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ARGUMENT_TYPE");
        this.value = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"VALUE");
        this.anyDataValue = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ANYDATA_VALUE");
        this.outArgument = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OUT_ARGUMENT");
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @NotNull
    public OracleDataSource getDataSource() {
        return this.job.getDataSource();
    }

    public OracleSchedulerJob getParentObject() {
        return this.job;
    }

    public boolean isPersisted() {
        return true;
    }

    @Property(viewable=true, order=10)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=11)
    public int getPosition() {
        return this.position;
    }

    @Property(viewable=true, order=12)
    public String getType() {
        return this.type;
    }

    @Property(viewable=true, order=14)
    public String getValue() {
        return this.value;
    }

    @Property(viewable=true, order=15)
    public String getAnyDataValue() {
        return this.anyDataValue;
    }

    @Property(viewable=true, order=16)
    public String getOutArgument() {
        return this.outArgument;
    }

    @NotNull
    public DBSTypedObject getParameterType() {
        return this.getDataSource().getLocalDataType(this.type);
    }
}

