/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import java.util.List;
import java.util.function.Predicate;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.driver.DriverUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceMenuContributor;
import org.jkiss.dbeaver.ui.dialogs.connection.NewConnectionDialog;

public class NewConnectionDriverSelectorContributor
extends DataSourceMenuContributor {
    private static final Log log = Log.getLog(NewConnectionDriverSelectorContributor.class);

    protected void fillContributionItems(List<IContributionItem> menuItems) {
        IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
        List allDrivers = DriverUtils.getAllDrivers();
        if (DBWorkbench.isDistributed()) {
            allDrivers.removeIf(Predicate.not(driver -> driver.getDefaultDriverLoader().isDriverInstalled()));
        }
        List recentDrivers = DriverUtils.getRecentDrivers((List)allDrivers, (int)10);
        for (DBPDriver driver2 : recentDrivers) {
            menuItems.add((IContributionItem)new ActionContributionItem((IAction)new NewConnectionAction(window, driver2)));
        }
        MenuManager allDriversMenu = new MenuManager("Other");
        for (DBPDriver driver3 : allDrivers) {
            if (recentDrivers.contains(driver3)) continue;
            allDriversMenu.add((IAction)new NewConnectionAction(window, driver3));
        }
        menuItems.add((IContributionItem)allDriversMenu);
    }

    private static class NewConnectionAction
    extends Action {
        private IWorkbenchWindow window;
        private DBPDriver driver;

        public NewConnectionAction(IWorkbenchWindow window, DBPDriver driver) {
            super(driver.getName(), DBeaverIcons.getImageDescriptor((DBPImage)driver.getIcon()));
            this.window = window;
            this.driver = driver;
        }

        public void run() {
            NewConnectionDialog.openNewConnectionDialog(this.window, this.driver, null);
        }
    }
}

