/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.crypto;

import com.joyent.manta.client.crypto.SupportedCipherDetails;
import com.joyent.manta.exception.MantaClientEncryptionException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class EncryptionContext {
    private transient SecretKey key;
    private final SupportedCipherDetails cipherDetails;
    private final Cipher cipher;
    private final boolean requireCloneableCipher;

    public EncryptionContext(SecretKey key, SupportedCipherDetails cipherDetails, boolean requireCloneableCipher) {
        this(key, cipherDetails, null, requireCloneableCipher);
    }

    EncryptionContext(SecretKey key, SupportedCipherDetails cipherDetails, byte[] suppliedIv, boolean requireCloneableCipher) {
        int keyBits = key.getEncoded().length << 3;
        if (keyBits != cipherDetails.getKeyLengthBits()) {
            String msg = "Mismatch between algorithm definition and secret key size";
            MantaClientEncryptionException e = new MantaClientEncryptionException(msg);
            e.setContextValue("cipherDetails", cipherDetails.toString());
            e.setContextValue("secretKeyAlgorithm", key.getAlgorithm());
            e.setContextValue("secretKeySizeInBits", String.valueOf(keyBits));
            e.setContextValue("expectedKeySizeInBits", cipherDetails.getKeyLengthBits());
            throw e;
        }
        this.key = key;
        this.requireCloneableCipher = requireCloneableCipher;
        this.cipherDetails = cipherDetails;
        this.cipher = requireCloneableCipher ? cipherDetails.getCloneableCipher() : cipherDetails.getCipher();
        this.initializeCipher(suppliedIv);
    }

    public SecretKey getSecretKey() {
        return this.key;
    }

    public void setKey(SecretKey key) {
        this.key = key;
    }

    public SupportedCipherDetails getCipherDetails() {
        return this.cipherDetails;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    public boolean requireCloneableCipher() {
        return this.requireCloneableCipher;
    }

    private void initializeCipher(byte[] suppliedIv) {
        try {
            byte[] iv = suppliedIv != null ? suppliedIv : this.cipherDetails.generateIv();
            this.cipher.init(1, (Key)this.key, this.cipherDetails.getEncryptionParameterSpec(iv));
        }
        catch (InvalidKeyException e) {
            MantaClientEncryptionException mcee = new MantaClientEncryptionException("There was a problem loading private key", e);
            String details = String.format("key=%s, algorithm=%s", this.key.getAlgorithm(), this.key.getFormat());
            mcee.setContextValue("key_details", details);
            throw mcee;
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new MantaClientEncryptionException("There was a problem with the passed algorithm parameters", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptionContext)) {
            return false;
        }
        EncryptionContext that = (EncryptionContext)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.cipherDetails, that.cipherDetails) && this.requireCloneableCipher == that.requireCloneableCipher;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.cipherDetails, this.requireCloneableCipher);
    }
}

