/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http;

import com.joyent.manta.http.HttpRange;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpException;
import org.apache.http.ProtocolException;

final class HttpDownloadContinuationMarker {
    private final String etag;
    private final long originalRangeStart;
    private final long totalRangeSize;
    private HttpRange.BoundedRequest currentRange;

    HttpDownloadContinuationMarker(String etag, HttpRange.Response initialContentRange) {
        Validate.validState((boolean)StringUtils.isNotBlank((CharSequence)etag), (String)"ETag must not be null or blank", (Object[])new Object[0]);
        Validate.notNull((Object)initialContentRange, (String)"HttpRange must not be null", (Object[])new Object[0]);
        this.etag = etag;
        this.originalRangeStart = initialContentRange.getStartInclusive();
        this.totalRangeSize = initialContentRange.getSize();
        this.currentRange = new HttpRange.BoundedRequest(this.originalRangeStart, initialContentRange.getEndInclusive());
    }

    String getEtag() {
        return this.etag;
    }

    HttpRange.BoundedRequest getCurrentRange() {
        return this.currentRange;
    }

    long getTotalRangeSize() {
        return this.totalRangeSize;
    }

    void updateRangeStart(long totalBytesRead) {
        HttpRange.BoundedRequest nextRange;
        long nextStartInclusive = this.originalRangeStart + totalBytesRead;
        if (totalBytesRead < 0L) {
            throw new IllegalArgumentException(String.format("Bytes read [%d] cannot be negative", totalBytesRead));
        }
        if (nextStartInclusive < this.currentRange.getStartInclusive()) {
            throw new IllegalArgumentException(String.format("Next start position [%d] cannot decrease, previously [%d]", nextStartInclusive, this.currentRange.getStartInclusive()));
        }
        if (this.totalRangeSize < totalBytesRead) {
            throw new IllegalArgumentException(String.format("Bytes read [%d] cannot be greater than expected number of bytes [%d]", totalBytesRead, this.totalRangeSize));
        }
        if (this.currentRange.getEndInclusive() < nextStartInclusive) {
            throw new IllegalArgumentException(String.format("Next start position [%d] cannot be greater than end of range [%d]", nextStartInclusive, this.currentRange.getEndInclusive()));
        }
        try {
            nextRange = new HttpRange.BoundedRequest(nextStartInclusive, this.currentRange.getEndInclusive());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to construct updated HttpRange: " + e.getMessage(), e);
        }
        this.currentRange = nextRange;
    }

    void validateResponseRange(HttpRange.Response responseRange) throws HttpException {
        if (!this.currentRange.matches(responseRange)) {
            throw new HttpException(String.format("Content-Range mismatch: expected: [%d-%d], got [%d-%d]", this.currentRange.getStartInclusive(), this.currentRange.getEndInclusive(), responseRange.getStartInclusive(), responseRange.getEndInclusive()));
        }
    }

    static HttpDownloadContinuationMarker validateInitialExchange(Pair<String, HttpRange.Request> requestHints, int responseCode, Pair<String, HttpRange.Response> responseFingerprint) throws ProtocolException {
        boolean rangeRequest;
        if (requestHints.getLeft() != null && !((String)requestHints.getLeft()).equals(responseFingerprint.getLeft())) {
            throw new ProtocolException(String.format("ETag does not match If-Match: If-Match [%s], ETag [%s]", requestHints.getLeft(), responseFingerprint.getLeft()));
        }
        boolean bl = rangeRequest = requestHints.getRight() != null;
        if (rangeRequest && !((HttpRange.Request)requestHints.getRight()).matches((HttpRange)responseFingerprint.getRight())) {
            throw new ProtocolException(String.format("Content-Range does not match Request range: Range [%s], Content-Range [%s]", requestHints.getRight(), responseFingerprint.getRight()));
        }
        if (rangeRequest && responseCode != 206) {
            throw new ProtocolException(String.format("Unexpected response code for range request: expected [%d], got [%d]", 206, responseCode));
        }
        if (!rangeRequest && responseCode != 200) {
            throw new ProtocolException(String.format("Unexpected response code for non-range request: expected [%d], got [%d]", 200, responseCode));
        }
        return new HttpDownloadContinuationMarker((String)responseFingerprint.getLeft(), (HttpRange.Response)responseFingerprint.getRight());
    }

    public String toString() {
        return "HttpDownloadContinuationMarker{etag='" + this.etag + '\'' + ", originalRangeStart=" + this.originalRangeStart + ", totalRangeSize=" + this.totalRangeSize + ", currentRange=" + this.currentRange + '}';
    }
}

