/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import java.util.ArrayList;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.ProtocolFormException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.KeyValuePair;
import org.irods.jargon.core.packinstr.Tag;

public class DataObjInpForReg
extends AbstractIRODSPackingInstruction {
    public static final int OBJ_REG_API_NBR = 630;
    private final String physicalFIleAbsolutePath;
    private final String irodsFileAbsolutePath;
    private final String resourceGroup;
    private final String resourceToStoreTo;
    private final boolean force;
    private final boolean recursive;
    private final boolean registerAsReplica;
    private ChecksumHandling checksumHandling;
    private String localFileChecksumValue;
    private int operationType = 0;

    public static final DataObjInpForReg instance(String physicalFileAbsolutePath, String irodsFileAbsolutePath, String resourceGroup, String resourceToStoreTo, boolean force, boolean recursive, ChecksumHandling checksumHandling, boolean registerAsReplica, String localFileChecksumValue) throws JargonException {
        return new DataObjInpForReg(physicalFileAbsolutePath, irodsFileAbsolutePath, resourceGroup, resourceToStoreTo, force, recursive, checksumHandling, registerAsReplica, localFileChecksumValue);
    }

    private DataObjInpForReg(String physicalFileAbsolutePath, String irodsFileAbsolutePath, String resourceGroup, String resourceToStoreTo, boolean force, boolean recursive, ChecksumHandling checksumHandling, boolean registerAsReplica, String localFileChecksumValue) throws JargonException {
        if (physicalFileAbsolutePath == null || physicalFileAbsolutePath.length() == 0) {
            throw new IllegalArgumentException("physicalFileAbsolutePath is null or empty");
        }
        if (irodsFileAbsolutePath == null || irodsFileAbsolutePath.length() == 0) {
            throw new IllegalArgumentException("irodsFileAbsolutePath is null or empty");
        }
        if (resourceGroup == null) {
            throw new IllegalArgumentException("null resource group, set to blank");
        }
        if (resourceToStoreTo == null) {
            throw new IllegalArgumentException("null resourceToStoreTo, set to blank");
        }
        if (checksumHandling == null) {
            throw new IllegalArgumentException("null checksumHandling");
        }
        if (localFileChecksumValue == null) {
            throw new IllegalArgumentException("null localFileChecksumValue, set to blank if not used");
        }
        if (checksumHandling == ChecksumHandling.VERFIY_CHECKSUM && localFileChecksumValue.isEmpty()) {
            throw new ProtocolFormException("verify checksum was indicated, but no local checksum provided");
        }
        if (recursive && (checksumHandling == ChecksumHandling.VERFIY_CHECKSUM || checksumHandling == ChecksumHandling.REGISTER_CHECKSUM)) {
            throw new ProtocolFormException("unable to verify regiseter or verify a checksum when registering a collection");
        }
        this.physicalFIleAbsolutePath = physicalFileAbsolutePath;
        this.irodsFileAbsolutePath = irodsFileAbsolutePath;
        this.resourceGroup = resourceGroup;
        this.resourceToStoreTo = resourceToStoreTo;
        this.force = force;
        this.recursive = recursive;
        this.checksumHandling = checksumHandling;
        this.registerAsReplica = registerAsReplica;
        this.localFileChecksumValue = localFileChecksumValue;
        this.setApiNumber(630);
    }

    @Override
    public Tag getTagValue() throws JargonException {
        Tag message = new Tag("DataObjInp_PI", new Tag[]{new Tag("objPath", this.irodsFileAbsolutePath), new Tag("createMode", 0), new Tag("openFlags", 0), new Tag("offset", 0), new Tag("dataSize", 0), new Tag("numThreads", 0), new Tag("oprType", this.operationType)});
        ArrayList<KeyValuePair> kvps = new ArrayList<KeyValuePair>();
        kvps.add(KeyValuePair.instance("dataType", "generic"));
        kvps.add(KeyValuePair.instance("filePath", this.physicalFIleAbsolutePath));
        if (this.recursive) {
            kvps.add(KeyValuePair.instance("collection", ""));
        }
        if (this.force) {
            kvps.add(KeyValuePair.instance("forceFlag", ""));
        }
        kvps.add(KeyValuePair.instance("destRescName", this.resourceToStoreTo));
        if (!this.resourceGroup.isEmpty()) {
            if (this.resourceToStoreTo.isEmpty()) {
                throw new ProtocolFormException("if a resource group is specified, a resource must be specified");
            }
            kvps.add(KeyValuePair.instance("rescGroupName", this.resourceGroup));
        }
        if (this.registerAsReplica) {
            kvps.add(KeyValuePair.instance("regRepl", ""));
        }
        if (this.checksumHandling == ChecksumHandling.REGISTER_CHECKSUM) {
            kvps.add(KeyValuePair.instance("verifyChksum", ""));
        } else if (this.checksumHandling == ChecksumHandling.VERFIY_CHECKSUM) {
            kvps.add(KeyValuePair.instance("regChksum", this.localFileChecksumValue));
        }
        message.addTag(this.createKeyValueTag(kvps));
        return message;
    }

    public static enum ChecksumHandling {
        NONE,
        REGISTER_CHECKSUM,
        VERFIY_CHECKSUM;

    }
}

