/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.importer;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.importer.JsonBookmarkCollection;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class ExpandriveBookmarkCollection
extends JsonBookmarkCollection {
    private static final Logger log = Logger.getLogger(ExpandriveBookmarkCollection.class);

    @Override
    protected void parse(ProtocolFactory protocols, Local file) throws AccessDeniedException {
        try {
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8));
            reader.beginArray();
            while (reader.hasNext()) {
                reader.beginObject();
                Host current = new Host(protocols.forScheme(Scheme.ftp));
                boolean skip = false;
                block23: while (reader.hasNext()) {
                    String name;
                    switch (name = reader.nextName()) {
                        case "server": {
                            String hostname = this.readNext(name, reader);
                            if (StringUtils.isBlank((CharSequence)hostname)) {
                                skip = true;
                                continue block23;
                            }
                            current.setHostname(hostname);
                            continue block23;
                        }
                        case "username": {
                            current.getCredentials().setUsername(this.readNext(name, reader));
                            continue block23;
                        }
                        case "private_key_file": {
                            String key = this.readNext(name, reader);
                            if (!StringUtils.isNotBlank((CharSequence)key)) continue block23;
                            current.getCredentials().setIdentity(LocalFactory.get((String)key));
                            continue block23;
                        }
                        case "remotePath": {
                            current.setDefaultPath(this.readNext(name, reader));
                            continue block23;
                        }
                        case "type": {
                            Protocol type = protocols.forName(this.readNext(name, reader));
                            if (null == type) continue block23;
                            current.setProtocol(type);
                            continue block23;
                        }
                        case "protocol": {
                            Protocol protocol = protocols.forName(this.readNext(name, reader));
                            if (null == protocol) continue block23;
                            current.setProtocol(protocol);
                            current.setPort(-1);
                            continue block23;
                        }
                        case "name": {
                            current.setNickname(this.readNext(name, reader));
                            continue block23;
                        }
                        case "region": {
                            current.setRegion(this.readNext(name, reader));
                            continue block23;
                        }
                    }
                    log.warn((Object)String.format("Ignore property %s", name));
                    reader.skipValue();
                }
                reader.endObject();
                if (skip) continue;
                this.add(current);
            }
            reader.endArray();
        }
        catch (IOException | IllegalStateException e) {
            throw new LocalAccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }
}

