/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.sds.SDSMoveFeature;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPathContainerService;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Collections;
import org.apache.log4j.Logger;

public class SDSDelegatingMoveFeature
implements Move {
    private static final Logger log = Logger.getLogger(SDSDelegatingMoveFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final SDSMoveFeature proxy;
    private final PathContainerService containerService = new SDSPathContainerService();

    public SDSDelegatingMoveFeature(SDSSession session, SDSNodeIdProvider nodeid, SDSMoveFeature proxy) {
        this.session = session;
        this.nodeid = nodeid;
        this.proxy = proxy;
    }

    public Path move(Path source, Path target, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        if (this.containerService.isContainer(source) && new SimplePathPredicate(source.getParent()).test(target.getParent())) {
            return this.proxy.move(source, target, status, callback, connectionCallback);
        }
        if (this.nodeid.isEncrypted(source) ^ this.nodeid.isEncrypted(target)) {
            Copy copy = (Copy)this.session.getFeature(Copy.class);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Move %s to %s using copy feature %s", source, target, copy));
            }
            Path c = copy.copy(source, target, status, connectionCallback);
            Delete delete = (Delete)this.session.getFeature(Delete.class);
            if (delete.isSupported(source)) {
                log.warn((Object)String.format("Delete source %s copied to %s", source, target));
                delete.delete(Collections.singletonMap(source, status), (PasswordCallback)connectionCallback, callback);
            }
            return c;
        }
        return this.proxy.move(source, target, status, callback, connectionCallback);
    }

    public boolean isRecursive(Path source, Path target) {
        if (this.nodeid.isEncrypted(source) ^ this.nodeid.isEncrypted(target)) {
            return ((Copy)this.session.getFeature(Copy.class)).isRecursive(source, target);
        }
        return this.proxy.isRecursive(source, target);
    }

    public boolean isSupported(Path source, Path target) {
        if (this.nodeid.isEncrypted(source) ^ this.nodeid.isEncrypted(target)) {
            return ((Copy)this.session.getFeature(Copy.class)).isSupported(source, target);
        }
        return this.proxy.isSupported(source, target);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SDSDelegatingMoveFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

