/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.sds.SDSAttributesFinderFeature;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.shared.DefaultAclFeature;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class SDSPermissionsFeature
extends DefaultAclFeature {
    private static final Logger log = Logger.getLogger(SDSPermissionsFeature.class);
    public static final Acl.Role MANAGE_ROLE = new Acl.Role("MANAGE_ROLE");
    public static final Acl.Role READ_ROLE = new Acl.Role("READ");
    public static final Acl.Role CREATE_ROLE = new Acl.Role("CREATE");
    public static final Acl.Role CHANGE_ROLE = new Acl.Role("CHANGE");
    public static final Acl.Role DELETE_ROLE = new Acl.Role("DELETE");
    public static final Acl.Role DOWNLOAD_SHARE_ROLE = new Acl.Role("DOWNLOAD_SHARE");
    public static final Acl.Role UPLOAD_SHARE_ROLE = new Acl.Role("UPLOAD_SHARE");
    public static final Acl.Role ROOM_MANAGER_ROLE = new Acl.Role("ROOM_MANAGER");
    public static final Acl.Role GROUP_MANAGER_ROLE = new Acl.Role("GROUP_MANAGER");
    public static final Acl.Role USER_MANAGER_ROLE = new Acl.Role("USER_MANAGER");
    public static final Acl.Role CONFIG_MANAGER_ROLE = new Acl.Role("CONFIG_MANAGER");
    public static final Acl.Role LOG_AUDITOR_ROLE = new Acl.Role("LOG_AUDITOR");
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSPermissionsFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public Acl getPermission(Path file) throws BackgroundException {
        return new SDSAttributesFinderFeature(this.session, this.nodeid).find(file).getAcl();
    }

    public void setPermission(Path file, Acl acl) throws BackgroundException {
        throw new UnsupportedException();
    }

    public List<Acl.User> getAvailableAclUsers() {
        return Collections.singletonList(new Acl.CanonicalUser());
    }

    public List<Acl.Role> getAvailableAclRoles(List<Path> files) {
        return Arrays.asList(MANAGE_ROLE, READ_ROLE, CREATE_ROLE, CHANGE_ROLE, DELETE_ROLE, DOWNLOAD_SHARE_ROLE, UPLOAD_SHARE_ROLE);
    }

    public boolean containsRole(Path file, Acl.Role role) {
        if (Acl.EMPTY == file.attributes().getAcl()) {
            log.warn((Object)String.format("Unknown ACLs on %s", file));
            return true;
        }
        if (file.attributes().getAcl().isEmpty()) {
            log.warn((Object)String.format("No ACLs found for %s", file));
            return false;
        }
        Set roles = (Set)file.attributes().getAcl().get((Object)new Acl.CanonicalUser());
        if (null == roles) {
            log.warn((Object)String.format("Missing roles in ACL for %s", file));
            return false;
        }
        boolean found = roles.contains(role);
        if (!found) {
            log.warn((Object)String.format("Missing role %s in ACL for %s", role, file));
        }
        return found;
    }
}

