/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.VersioningConfiguration;
import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.RestoreDeletedNodesRequest;

public class SDSVersioningFeature
implements Versioning {
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;

    public SDSVersioningFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public VersioningConfiguration getConfiguration(Path container) {
        return VersioningConfiguration.empty();
    }

    public void setConfiguration(Path container, PasswordCallback prompt, VersioningConfiguration configuration) throws BackgroundException {
        throw new InteroperabilityException();
    }

    public void revert(Path file) throws BackgroundException {
        try {
            new NodesApi((ApiClient)this.session.getClient()).restoreNodes(new RestoreDeletedNodesRequest().resolutionStrategy(RestoreDeletedNodesRequest.ResolutionStrategyEnum.OVERWRITE).keepShareLinks(PreferencesFactory.get().getBoolean("sds.upload.sharelinks.keep")).addDeletedNodeIdsItem(Long.parseLong(this.nodeid.getFileid(file, (ListProgressListener)new DisabledListProgressListener()))).parentId(Long.parseLong(this.nodeid.getFileid(file.getParent(), (ListProgressListener)new DisabledListProgressListener()))), "");
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
    }

    public boolean isRevertable(Path file) {
        return true;
    }

    public Credentials getToken(String mfaSerial, PasswordCallback callback) throws ConnectionCanceledException {
        return null;
    }

    public Versioning withCache(LRUCache<Path, VersioningConfiguration> cache) {
        return this;
    }
}

