/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.S3FileUploadPart;
import ch.cyberduck.core.sds.io.swagger.client.model.UserFileKey;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Request model for completing a S3 file upload")
public class CompleteS3ShareUploadRequest {
    @JsonProperty(value="parts")
    private List<S3FileUploadPart> parts = new ArrayList<S3FileUploadPart>();
    @JsonProperty(value="userFileKeyList")
    private List<UserFileKey> userFileKeyList = null;

    public CompleteS3ShareUploadRequest parts(List<S3FileUploadPart> parts) {
        this.parts = parts;
        return this;
    }

    public CompleteS3ShareUploadRequest addPartsItem(S3FileUploadPart partsItem) {
        this.parts.add(partsItem);
        return this;
    }

    @Schema(required=true, description="List of S3 file upload parts")
    public List<S3FileUploadPart> getParts() {
        return this.parts;
    }

    public void setParts(List<S3FileUploadPart> parts) {
        this.parts = parts;
    }

    public CompleteS3ShareUploadRequest userFileKeyList(List<UserFileKey> userFileKeyList) {
        this.userFileKeyList = userFileKeyList;
        return this;
    }

    public CompleteS3ShareUploadRequest addUserFileKeyListItem(UserFileKey userFileKeyListItem) {
        if (this.userFileKeyList == null) {
            this.userFileKeyList = new ArrayList<UserFileKey>();
        }
        this.userFileKeyList.add(userFileKeyListItem);
        return this;
    }

    @Schema(description="List of user file keys")
    public List<UserFileKey> getUserFileKeyList() {
        return this.userFileKeyList;
    }

    public void setUserFileKeyList(List<UserFileKey> userFileKeyList) {
        this.userFileKeyList = userFileKeyList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompleteS3ShareUploadRequest completeS3ShareUploadRequest = (CompleteS3ShareUploadRequest)o;
        return Objects.equals(this.parts, completeS3ShareUploadRequest.parts) && Objects.equals(this.userFileKeyList, completeS3ShareUploadRequest.userFileKeyList);
    }

    public int hashCode() {
        return Objects.hash(this.parts, this.userFileKeyList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompleteS3ShareUploadRequest {\n");
        sb.append("    parts: ").append(this.toIndentedString(this.parts)).append("\n");
        sb.append("    userFileKeyList: ").append(this.toIndentedString(this.userFileKeyList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

