/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="Deleted node information (Deleted node can be a folder or file)")
public class DeletedNodeSummary {
    @JsonProperty(value="parentId")
    private Long parentId = null;
    @JsonProperty(value="parentPath")
    private String parentPath = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="type")
    private TypeEnum type = null;
    @JsonProperty(value="cntVersions")
    private Integer cntVersions = null;
    @JsonProperty(value="firstDeletedAt")
    private DateTime firstDeletedAt = null;
    @JsonProperty(value="lastDeletedAt")
    private DateTime lastDeletedAt = null;
    @JsonProperty(value="lastDeletedNodeId")
    private Long lastDeletedNodeId = null;
    @JsonProperty(value="timestampCreation")
    private DateTime timestampCreation = null;
    @JsonProperty(value="timestampModification")
    private DateTime timestampModification = null;

    public DeletedNodeSummary parentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    @Schema(required=true, description="Parent node ID (room or folder)")
    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public DeletedNodeSummary parentPath(String parentPath) {
        this.parentPath = parentPath;
        return this;
    }

    @Schema(required=true, description="Parent node path  `/` if node is a root node (room)")
    public String getParentPath() {
        return this.parentPath;
    }

    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public DeletedNodeSummary name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="Node name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeletedNodeSummary type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(required=true, description="Node type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public DeletedNodeSummary cntVersions(Integer cntVersions) {
        this.cntVersions = cntVersions;
        return this;
    }

    @Schema(required=true, description="Number of deleted versions of this file")
    public Integer getCntVersions() {
        return this.cntVersions;
    }

    public void setCntVersions(Integer cntVersions) {
        this.cntVersions = cntVersions;
    }

    public DeletedNodeSummary firstDeletedAt(DateTime firstDeletedAt) {
        this.firstDeletedAt = firstDeletedAt;
        return this;
    }

    @Schema(required=true, description="First deleted version")
    public DateTime getFirstDeletedAt() {
        return this.firstDeletedAt;
    }

    public void setFirstDeletedAt(DateTime firstDeletedAt) {
        this.firstDeletedAt = firstDeletedAt;
    }

    public DeletedNodeSummary lastDeletedAt(DateTime lastDeletedAt) {
        this.lastDeletedAt = lastDeletedAt;
        return this;
    }

    @Schema(required=true, description="Last deleted version")
    public DateTime getLastDeletedAt() {
        return this.lastDeletedAt;
    }

    public void setLastDeletedAt(DateTime lastDeletedAt) {
        this.lastDeletedAt = lastDeletedAt;
    }

    public DeletedNodeSummary lastDeletedNodeId(Long lastDeletedNodeId) {
        this.lastDeletedNodeId = lastDeletedNodeId;
        return this;
    }

    @Schema(required=true, description="Node ID of last deleted version")
    public Long getLastDeletedNodeId() {
        return this.lastDeletedNodeId;
    }

    public void setLastDeletedNodeId(Long lastDeletedNodeId) {
        this.lastDeletedNodeId = lastDeletedNodeId;
    }

    public DeletedNodeSummary timestampCreation(DateTime timestampCreation) {
        this.timestampCreation = timestampCreation;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.22.0  Time the node was created on external file system")
    public DateTime getTimestampCreation() {
        return this.timestampCreation;
    }

    public void setTimestampCreation(DateTime timestampCreation) {
        this.timestampCreation = timestampCreation;
    }

    public DeletedNodeSummary timestampModification(DateTime timestampModification) {
        this.timestampModification = timestampModification;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.22.0  Time the content of a node was last modified on external file system")
    public DateTime getTimestampModification() {
        return this.timestampModification;
    }

    public void setTimestampModification(DateTime timestampModification) {
        this.timestampModification = timestampModification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeletedNodeSummary deletedNodeSummary = (DeletedNodeSummary)o;
        return Objects.equals(this.parentId, deletedNodeSummary.parentId) && Objects.equals(this.parentPath, deletedNodeSummary.parentPath) && Objects.equals(this.name, deletedNodeSummary.name) && Objects.equals((Object)this.type, (Object)deletedNodeSummary.type) && Objects.equals(this.cntVersions, deletedNodeSummary.cntVersions) && Objects.equals(this.firstDeletedAt, deletedNodeSummary.firstDeletedAt) && Objects.equals(this.lastDeletedAt, deletedNodeSummary.lastDeletedAt) && Objects.equals(this.lastDeletedNodeId, deletedNodeSummary.lastDeletedNodeId) && Objects.equals(this.timestampCreation, deletedNodeSummary.timestampCreation) && Objects.equals(this.timestampModification, deletedNodeSummary.timestampModification);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.parentId, this.parentPath, this.name, this.type, this.cntVersions, this.firstDeletedAt, this.lastDeletedAt, this.lastDeletedNodeId, this.timestampCreation, this.timestampModification});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeletedNodeSummary {\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    parentPath: ").append(this.toIndentedString(this.parentPath)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    cntVersions: ").append(this.toIndentedString(this.cntVersions)).append("\n");
        sb.append("    firstDeletedAt: ").append(this.toIndentedString(this.firstDeletedAt)).append("\n");
        sb.append("    lastDeletedAt: ").append(this.toIndentedString(this.lastDeletedAt)).append("\n");
        sb.append("    lastDeletedNodeId: ").append(this.toIndentedString(this.lastDeletedNodeId)).append("\n");
        sb.append("    timestampCreation: ").append(this.toIndentedString(this.timestampCreation)).append("\n");
        sb.append("    timestampModification: ").append(this.toIndentedString(this.timestampModification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        FOLDER("folder"),
        FILE("file");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

