/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.joda.time.DateTime;

@Schema(description="OAuth client approval information")
public class OAuthApproval {
    @JsonProperty(value="clientId")
    private String clientId = null;
    @JsonProperty(value="clientName")
    private String clientName = null;
    @JsonProperty(value="expiresAt")
    private DateTime expiresAt = null;

    public OAuthApproval clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Schema(required=true, description="ID of the OAuth client")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public OAuthApproval clientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    @Schema(required=true, description="Name, which is shown at the client configuration and authorization.")
    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public OAuthApproval expiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Schema(description="Expiration date of the approval")
    public DateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(DateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthApproval oauthApproval = (OAuthApproval)o;
        return Objects.equals(this.clientId, oauthApproval.clientId) && Objects.equals(this.clientName, oauthApproval.clientName) && Objects.equals(this.expiresAt, oauthApproval.expiresAt);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.clientName, this.expiresAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthApproval {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientName: ").append(this.toIndentedString(this.clientName)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

