/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Request model for updating a webhook")
public class UpdateWebhookRequest {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="eventTypeNames")
    private List<String> eventTypeNames = null;
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="secret")
    private String secret = null;
    @JsonProperty(value="isEnabled")
    private Boolean isEnabled = null;
    @JsonProperty(value="triggerExampleEvent")
    private Boolean triggerExampleEvent = null;

    public UpdateWebhookRequest name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UpdateWebhookRequest eventTypeNames(List<String> eventTypeNames) {
        this.eventTypeNames = eventTypeNames;
        return this;
    }

    public UpdateWebhookRequest addEventTypeNamesItem(String eventTypeNamesItem) {
        if (this.eventTypeNames == null) {
            this.eventTypeNames = new ArrayList<String>();
        }
        this.eventTypeNames.add(eventTypeNamesItem);
        return this;
    }

    @Schema(description="List of names of event types")
    public List<String> getEventTypeNames() {
        return this.eventTypeNames;
    }

    public void setEventTypeNames(List<String> eventTypeNames) {
        this.eventTypeNames = eventTypeNames;
    }

    public UpdateWebhookRequest url(String url) {
        this.url = url;
        return this;
    }

    @Schema(description="URL (must begin with the `HTTPS` scheme)")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public UpdateWebhookRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Schema(description="Secret; used for event message signatures")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public UpdateWebhookRequest isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Schema(description="Is enabled")
    public Boolean isIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public UpdateWebhookRequest triggerExampleEvent(Boolean triggerExampleEvent) {
        this.triggerExampleEvent = triggerExampleEvent;
        return this;
    }

    @Schema(description="If set to true, an example event is being created")
    public Boolean isTriggerExampleEvent() {
        return this.triggerExampleEvent;
    }

    public void setTriggerExampleEvent(Boolean triggerExampleEvent) {
        this.triggerExampleEvent = triggerExampleEvent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateWebhookRequest updateWebhookRequest = (UpdateWebhookRequest)o;
        return Objects.equals(this.name, updateWebhookRequest.name) && Objects.equals(this.eventTypeNames, updateWebhookRequest.eventTypeNames) && Objects.equals(this.url, updateWebhookRequest.url) && Objects.equals(this.secret, updateWebhookRequest.secret) && Objects.equals(this.isEnabled, updateWebhookRequest.isEnabled) && Objects.equals(this.triggerExampleEvent, updateWebhookRequest.triggerExampleEvent);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.eventTypeNames, this.url, this.secret, this.isEnabled, this.triggerExampleEvent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateWebhookRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    eventTypeNames: ").append(this.toIndentedString(this.eventTypeNames)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    triggerExampleEvent: ").append(this.toIndentedString(this.triggerExampleEvent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

