/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="User information")
public class UserInfo {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="userType")
    private UserTypeEnum userType = null;
    @JsonProperty(value="avatarUuid")
    private String avatarUuid = null;
    @JsonProperty(value="userName")
    private String userName = null;
    @JsonProperty(value="firstName")
    private String firstName = null;
    @JsonProperty(value="lastName")
    private String lastName = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="displayName")
    private String displayName = null;

    public UserInfo id(Long id) {
        this.id = id;
        return this;
    }

    @Schema(required=true, description="Unique identifier for the user")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public UserInfo userType(UserTypeEnum userType) {
        this.userType = userType;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.11.0  User type:  * `internal` - ordinary DRACOON user  * `external` - external user without DRACOON account  * `system` - system user (non human &#128125;)  * `deleted` - deleted DRACOON user")
    public UserTypeEnum getUserType() {
        return this.userType;
    }

    public void setUserType(UserTypeEnum userType) {
        this.userType = userType;
    }

    public UserInfo avatarUuid(String avatarUuid) {
        this.avatarUuid = avatarUuid;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.11.0  Avatar UUID")
    public String getAvatarUuid() {
        return this.avatarUuid;
    }

    public void setAvatarUuid(String avatarUuid) {
        this.avatarUuid = avatarUuid;
    }

    public UserInfo userName(String userName) {
        this.userName = userName;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.13.0  Username (only returned for `internal` users)")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public UserInfo firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.11.0  User first name (mandatory if `userType` is `internal`)")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public UserInfo lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Schema(required=true, description="&#128640; Since v4.11.0  User last name (mandatory if `userType` is `internal`)")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public UserInfo email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="&#128640; Since v4.11.0  Email ")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public UserInfo title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.18.0  Job title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public UserInfo displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(description="&#128679; Deprecated since v4.11.0  Display name  use other fields from `UserInfo` instead to combine a display name")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserInfo userInfo = (UserInfo)o;
        return Objects.equals(this.id, userInfo.id) && Objects.equals((Object)this.userType, (Object)userInfo.userType) && Objects.equals(this.avatarUuid, userInfo.avatarUuid) && Objects.equals(this.userName, userInfo.userName) && Objects.equals(this.firstName, userInfo.firstName) && Objects.equals(this.lastName, userInfo.lastName) && Objects.equals(this.email, userInfo.email) && Objects.equals(this.title, userInfo.title) && Objects.equals(this.displayName, userInfo.displayName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.userType, this.avatarUuid, this.userName, this.firstName, this.lastName, this.email, this.title, this.displayName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserInfo {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    userType: ").append(this.toIndentedString((Object)this.userType)).append("\n");
        sb.append("    avatarUuid: ").append(this.toIndentedString(this.avatarUuid)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum UserTypeEnum {
        SYSTEM("system"),
        INTERNAL("internal"),
        EXTERNAL("external"),
        DELETED("deleted");

        private String value;

        private UserTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UserTypeEnum fromValue(String text) {
            for (UserTypeEnum b : UserTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

