/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import java.net.URL;
import java.util.Iterator;
import org.nuxeo.onedrive.client.JsonObjectIterator;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.URLTemplate;
import org.nuxeo.onedrive.client.types.GroupItem;
import org.nuxeo.onedrive.client.types.User;

public final class Groups {
    public static Iterator<GroupItem.Metadata> getMemberOfGroups(User user) {
        return new GroupItemIterator(user.getApi(), new URLTemplate(user.getOperationPath("/memberOf/$/microsoft.graph.group")).build(user.getApi().getBaseURL()));
    }

    private static final class GroupItemIterator
    implements Iterator<GroupItem.Metadata> {
        private final OneDriveAPI api;
        private final JsonObjectIterator iterator;

        public GroupItemIterator(OneDriveAPI api, URL url) {
            this.api = api;
            this.iterator = new JsonObjectIterator(api, url);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public GroupItem.Metadata next() {
            JsonObject root = this.iterator.next();
            return GroupItem.fromJson(this.api, root);
        }
    }
}

