/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import java.util.Objects;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveJsonObject;

public class OneDriveResource {
    private final OneDriveAPI api;
    private final String resourceIdentifier;

    public OneDriveResource(OneDriveAPI api) {
        this.api = Objects.requireNonNull(api);
        this.resourceIdentifier = null;
    }

    public OneDriveResource(OneDriveAPI api, String resourceIdentifier) {
        this.api = Objects.requireNonNull(api);
        this.resourceIdentifier = Objects.requireNonNull(resourceIdentifier);
    }

    public OneDriveAPI getApi() {
        return this.api;
    }

    public boolean isRoot() {
        return this.resourceIdentifier == null;
    }

    public String getItemIdentifier() {
        return this.resourceIdentifier;
    }

    public String getFullyQualifiedPath() {
        return "";
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        OneDriveResource oDObj = (OneDriveResource)obj;
        return this.getItemIdentifier().equals(oDObj.getItemIdentifier());
    }

    public int hashCode() {
        return this.getItemIdentifier().hashCode();
    }

    public abstract class Metadata
    extends OneDriveJsonObject {
        public Metadata(JsonObject json) {
            super(json);
        }

        public String getId() {
            return OneDriveResource.this.getItemIdentifier();
        }

        public abstract OneDriveResource getResource();
    }
}

