/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.preferences.PreferencesFactory;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.Ds3ClientImpl;
import com.spectralogic.ds3client.models.common.Credentials;
import com.spectralogic.ds3client.networking.ConnectionDetails;
import com.spectralogic.ds3client.networking.NetworkClient;
import com.spectralogic.ds3client.networking.NetworkClientImpl;
import java.net.URI;
import org.apache.http.impl.client.CloseableHttpClient;
import org.jets3t.service.impl.rest.httpclient.RestStorageService;

public class SpectraClientBuilder {
    public Ds3Client wrap(final RestStorageService client, final Host bookmark) {
        return new Ds3ClientImpl((NetworkClient)new NetworkClientImpl(new ConnectionDetails(){

            public String getEndpoint() {
                return String.format("%s:%d", bookmark.getHostname(), bookmark.getPort());
            }

            public Credentials getCredentials() {
                return new Credentials(client.getProviderCredentials().getAccessKey(), client.getProviderCredentials().getSecretKey());
            }

            public boolean isHttps() {
                return bookmark.getProtocol().getScheme() == Scheme.https;
            }

            public URI getProxy() {
                return null;
            }

            public int getRetries() {
                return 0;
            }

            public int getBufferSize() {
                return PreferencesFactory.get().getInteger("connection.chunksize");
            }

            public int getConnectionTimeout() {
                return PreferencesFactory.get().getInteger("connection.timeout.seconds") * 1000;
            }

            public int getSocketTimeout() {
                return PreferencesFactory.get().getInteger("connection.timeout.seconds") * 1000;
            }

            public boolean isCertificateVerification() {
                return true;
            }

            public String getUserAgent() {
                return new PreferencesUseragentProvider().get();
            }
        }, (CloseableHttpClient)client.getHttpClient()));
    }
}

