/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.s3.S3DisabledMultipartService;
import ch.cyberduck.core.s3.S3MultipartService;
import ch.cyberduck.core.s3.S3MultipleDeleteFeature;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.spectra.SpectraClientBuilder;
import ch.cyberduck.core.spectra.SpectraExceptionMappingService;
import ch.cyberduck.core.spectra.SpectraSession;
import ch.cyberduck.core.transfer.TransferStatus;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.commands.spectrads3.DeleteBucketSpectraS3Request;
import com.spectralogic.ds3client.commands.spectrads3.DeleteFolderRecursivelySpectraS3Request;
import com.spectralogic.ds3client.networking.FailedRequestException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jets3t.service.impl.rest.httpclient.RestStorageService;

public class SpectraDeleteFeature
extends S3MultipleDeleteFeature {
    private final PathContainerService containerService = new S3PathContainerService();
    private final SpectraSession session;

    public SpectraDeleteFeature(SpectraSession session) {
        super((S3Session)session, (S3MultipartService)new S3DisabledMultipartService());
        this.session = session;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        try {
            LinkedHashMap<Path, TransferStatus> filtered = new LinkedHashMap<Path, TransferStatus>(files);
            Iterator iter = filtered.entrySet().iterator();
            while (iter.hasNext()) {
                Ds3Client client;
                Map.Entry file = iter.next();
                if (this.containerService.isContainer((Path)file.getKey())) {
                    client = new SpectraClientBuilder().wrap((RestStorageService)this.session.getClient(), this.session.getHost());
                    client.deleteBucketSpectraS3(new DeleteBucketSpectraS3Request(this.containerService.getContainer((Path)file.getKey()).getName()).withForce(true));
                    iter.remove();
                    continue;
                }
                if (!((Path)file.getKey()).isDirectory()) continue;
                client = new SpectraClientBuilder().wrap((RestStorageService)this.session.getClient(), this.session.getHost());
                client.deleteFolderRecursivelySpectraS3(new DeleteFolderRecursivelySpectraS3Request(this.containerService.getContainer((Path)file.getKey()).getName(), this.containerService.getKey((Path)file.getKey())));
                iter.remove();
            }
            super.delete(filtered, prompt, callback);
        }
        catch (FailedRequestException e) {
            throw new SpectraExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public boolean isRecursive() {
        return true;
    }
}

