/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.cache.LRUCache;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractCache<T extends Referenceable>
implements Cache<T> {
    private static final Logger log = Logger.getLogger(AbstractCache.class);
    private final LRUCache<T, AttributedList<T>> impl;

    public AbstractCache(int size) {
        this.impl = size == Integer.MAX_VALUE ? LRUCache.build() : LRUCache.build(size);
    }

    @Override
    public T lookup(CacheReference<T> reference) {
        for (AttributedList<T> entry : this.impl.asMap().values()) {
            T f = entry.find(reference);
            if (null == f) continue;
            return f;
        }
        log.warn((Object)String.format("Lookup failed for %s in cache", reference));
        return null;
    }

    @Override
    public long size() {
        return this.impl.size();
    }

    @Override
    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    @Override
    public Map<T, AttributedList<T>> asMap() {
        return this.impl.asMap();
    }

    public boolean containsKey(T reference) {
        return this.impl.contains(reference);
    }

    @Override
    public AttributedList<T> remove(T reference) {
        AttributedList<T> removed = this.impl.get(reference);
        this.impl.remove(reference);
        if (null == removed) {
            return AttributedList.emptyList();
        }
        return removed;
    }

    @Override
    public AttributedList<T> get(T reference) {
        if (null == reference) {
            return AttributedList.emptyList();
        }
        AttributedList<T> children = this.impl.get(reference);
        if (null == children) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("No cache for %s", reference));
            }
            return AttributedList.emptyList();
        }
        return children;
    }

    @Override
    public AttributedList<T> put(T reference, AttributedList<T> children) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Caching %s", reference));
        }
        AttributedList<T> replaced = this.impl.get(reference);
        this.impl.put(reference, children);
        if (null == replaced) {
            return AttributedList.emptyList();
        }
        return replaced;
    }

    @Override
    public boolean isCached(T reference) {
        return this.containsKey(reference);
    }

    @Override
    public boolean isValid(T reference) {
        if (this.isCached(reference)) {
            return !this.get(reference).attributes().isInvalid();
        }
        return false;
    }

    @Override
    public void invalidate(T reference) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Invalidate %s", reference));
        }
        if (this.containsKey(reference)) {
            this.get(reference).attributes().setInvalid(true);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("No cache for %s", reference));
        }
    }

    @Override
    public void clear() {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Clear cache %s", this));
        }
        this.impl.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Cache{");
        sb.append("size=").append(this.impl.size());
        sb.append('}');
        return sb.toString();
    }
}

