/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostFilter;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class BookmarkSearchFilter
implements HostFilter {
    private final String searchString;

    public BookmarkSearchFilter(String searchString) {
        this.searchString = searchString;
    }

    @Override
    public boolean accept(Host bookmark) {
        String[] elements;
        for (String search : elements = StringUtils.split((String)StringUtils.lowerCase((String)this.searchString, (Locale)Locale.ROOT))) {
            if (StringUtils.lowerCase((String)BookmarkNameProvider.toString(bookmark), (Locale)Locale.ROOT).contains(search)) {
                return true;
            }
            if (null != bookmark.getCredentials().getUsername() && StringUtils.lowerCase((String)bookmark.getCredentials().getUsername(), (Locale)Locale.ROOT).contains(search)) {
                return true;
            }
            if (null != bookmark.getComment() && StringUtils.lowerCase((String)bookmark.getComment(), (Locale)Locale.ROOT).contains(search)) {
                return true;
            }
            if (StringUtils.lowerCase((String)bookmark.getHostname(), (Locale)Locale.ROOT).contains(search)) {
                return true;
            }
            for (String label : bookmark.getLabels()) {
                if (!StringUtils.lowerCase((String)label, (Locale)Locale.ROOT).contains(search)) continue;
                return true;
            }
        }
        return false;
    }
}

