/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.CollectionListener;
import ch.cyberduck.core.exception.AccessDeniedException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.apache.log4j.Logger;

public class Collection<E>
extends ArrayList<E>
implements CollectionListener<E> {
    private static final Logger log = Logger.getLogger(Collection.class);
    private final ReentrantLock locked = new ReentrantLock();
    private final AtomicBoolean loaded = new AtomicBoolean();
    private final Set<CollectionListener<E>> listeners = new CopyOnWriteArraySet<CollectionListener<E>>();

    public Collection() {
    }

    public Collection(java.util.Collection c) {
        super(c);
    }

    public void load() throws AccessDeniedException {
        this.collectionLoaded();
    }

    public void save() {
    }

    public void addListener(CollectionListener<E> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CollectionListener<E> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean addAll(java.util.Collection<? extends E> c) {
        ArrayList<E> temporary = new ArrayList<E>();
        for (Object item : c) {
            if (temporary.contains(item)) {
                log.warn((Object)String.format("Skip adding duplicate %s", item));
                continue;
            }
            temporary.add(item);
        }
        if (super.addAll(temporary)) {
            for (Object item : temporary) {
                this.collectionItemAdded((E)item);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int index, java.util.Collection<? extends E> c) {
        ArrayList<E> temporary = new ArrayList<E>();
        for (Object item : c) {
            if (temporary.contains(item)) {
                log.warn((Object)String.format("Skip adding duplicate %s", item));
                continue;
            }
            temporary.add(item);
        }
        if (super.addAll(index, temporary)) {
            for (Object item : temporary) {
                this.collectionItemAdded((E)item);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean add(E item) {
        if (this.contains(item)) {
            log.warn((Object)String.format("Skip adding duplicate %s", item));
            return false;
        }
        if (super.add(item)) {
            this.collectionItemAdded(item);
            return true;
        }
        return false;
    }

    @Override
    public void add(int row, E item) {
        if (this.contains(item)) {
            log.warn((Object)String.format("Skip adding duplicate %s", item));
            return;
        }
        super.add(row, item);
        this.collectionItemAdded(item);
    }

    public void replace(int row, E item) {
        super.remove(row);
        super.add(row, item);
        for (CollectionListener<E> listener : this.listeners) {
            listener.collectionItemChanged(item);
        }
    }

    @Override
    public void clear() {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    public E remove(int row) {
        Object previous = super.remove(row);
        if (previous != null) {
            this.collectionItemRemoved((E)previous);
        }
        return previous;
    }

    @Override
    public boolean remove(Object item) {
        if (super.remove(item)) {
            this.collectionItemRemoved((E)item);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(java.util.Collection<?> c) {
        if (super.removeAll(c)) {
            for (Object item : c) {
                this.collectionItemRemoved((E)item);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIf(final Predicate<? super E> filter) {
        final HashSet removed = new HashSet();
        boolean r = super.removeIf(new Predicate<E>(){

            @Override
            public boolean test(E e) {
                if (filter.test(e)) {
                    removed.add(e);
                    return true;
                }
                return false;
            }
        });
        for (Object e : removed) {
            this.collectionItemRemoved((E)e);
        }
        return r;
    }

    @Override
    public void collectionLoaded() {
        this.loaded.set(true);
        if (this.isLocked()) {
            log.debug((Object)"Do not notify changes of locked collection");
            return;
        }
        for (CollectionListener<E> listener : this.listeners) {
            listener.collectionLoaded();
        }
    }

    @Override
    public void collectionItemAdded(E item) {
        if (this.isLocked()) {
            log.debug((Object)"Do not notify changes of locked collection");
            return;
        }
        for (CollectionListener<E> listener : this.listeners) {
            listener.collectionItemAdded(item);
        }
    }

    @Override
    public void collectionItemRemoved(E item) {
        if (this.isLocked()) {
            log.debug((Object)"Do not notify changes of locked collection");
            return;
        }
        for (CollectionListener<E> listener : this.listeners) {
            listener.collectionItemRemoved(item);
        }
    }

    @Override
    public void collectionItemChanged(E item) {
        if (this.isLocked()) {
            log.debug((Object)"Do not notify changes of locked collection");
            return;
        }
        for (CollectionListener<E> listener : this.listeners) {
            listener.collectionItemChanged(item);
        }
    }

    public boolean isLoaded() {
        return this.loaded.get();
    }

    public boolean isLocked() {
        return this.locked.isLocked();
    }

    protected void lock() {
        this.locked.lock();
    }

    protected void unlock() {
        this.locked.unlock();
    }
}

