/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.DefaultHostPasswordStore;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.local.DefaultLocalDirectoryFeature;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class UnsecureHostPasswordStore
extends DefaultHostPasswordStore {
    private static final Logger log = Logger.getLogger(UnsecureHostPasswordStore.class);
    private final Local file = LocalFactory.get(SupportDirectoryFinderFactory.get().find(), "credentials");

    private Properties load() {
        Properties properties = new Properties();
        try {
            new DefaultLocalDirectoryFeature().mkdir(this.file.getParent());
        }
        catch (AccessDeniedException e) {
            log.warn((Object)String.format("Failure saving credentials to %s. %s", this.file.getAbsolute(), e));
        }
        if (this.file.exists()) {
            try (InputStream in = this.file.getInputStream();){
                properties.load(in);
            }
            catch (AccessDeniedException | IOException | IllegalArgumentException e) {
                log.warn((Object)String.format("Failure reading credentials from %s. %s", this.file.getAbsolute(), e));
            }
        }
        return properties;
    }

    private void save(Properties properties) {
        try (OutputStream out = this.file.getOutputStream(false);){
            properties.store(out, "Credentials");
        }
        catch (AccessDeniedException e) {
            log.warn((Object)String.format("Failure saving credentials to %s. %s", this.file.getAbsolute(), e));
        }
        catch (IOException e) {
            log.warn((Object)String.format("Failure saving credentials to %s. %s", this.file.getAbsolute(), e.getMessage()));
        }
    }

    @Override
    public String getPassword(String serviceName, String accountName) {
        return this.load().getProperty(String.format("%s@%s", accountName, serviceName), null);
    }

    @Override
    public void addPassword(String serviceName, String accountName, String password) {
        Properties properties = this.load();
        properties.setProperty(String.format("%s@%s", accountName, serviceName), password);
        this.save(properties);
    }

    @Override
    public String getPassword(Scheme scheme, int port, String hostname, String user) {
        return this.load().getProperty(String.format("%s://%s@%s:%d", new Object[]{scheme, user, hostname, port}), null);
    }

    @Override
    public void addPassword(Scheme scheme, int port, String hostname, String user, String password) {
        Properties properties = this.load();
        properties.setProperty(String.format("%s://%s@%s:%d", new Object[]{scheme, user, hostname, port}), password);
        this.save(properties);
    }

    @Override
    public void deletePassword(String serviceName, String accountName) {
        Properties properties = this.load();
        properties.remove(String.format("%s@%s", accountName, serviceName));
        this.save(properties);
    }

    @Override
    public void deletePassword(Scheme scheme, int port, String hostname, String user) {
        Properties properties = this.load();
        properties.remove(String.format("%s://%s@%s:%d", new Object[]{scheme, user, hostname, port}));
        this.save(properties);
    }
}

