/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.cdn.features.Index;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ReadDistributionWorker
extends Worker<Distribution> {
    private final List<Path> files;
    private final LoginCallback prompt;
    private final Distribution.Method method;

    public ReadDistributionWorker(List<Path> files, LoginCallback prompt, Distribution.Method method) {
        this.files = files;
        this.prompt = prompt;
        this.method = method;
    }

    @Override
    public Distribution run(Session<?> session) throws BackgroundException {
        DistributionConfiguration cdn = session.getFeature(DistributionConfiguration.class);
        Iterator<Path> iterator = this.getContainers(this.files).iterator();
        if (iterator.hasNext()) {
            Path file = iterator.next();
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            Distribution distribution = cdn.read(file, this.method, this.prompt);
            if (cdn.getFeature(Index.class, distribution.getMethod()) != null) {
                distribution.setRootDocuments(session.getFeature(ListService.class).list(this.containerService.getContainer(file), new DisabledListProgressListener()).toList());
            }
            return distribution;
        }
        return this.initialize();
    }

    @Override
    public Distribution initialize() {
        return new Distribution(this.method, false);
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Reading CDN configuration of {0}", "Status"), this.toString(this.files));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadDistributionWorker that = (ReadDistributionWorker)o;
        return Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ReadDistributionWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

